///////////////////////////////////////////////////////////////////////////////////////
//                                                                                    
//                       OpenGL Basic View                                                                                     
//                                        
// date: 1999.7.13 : dll conversion 
//       1999. 9. 15. WED : Remarks added
//      
// author: Jongwhan Lee (leejw51@cubic.re.kr)                                                                                    
//                                                                                    
// 
// no message handler isn't declared here for maximum flexibility
// you make your own child frame for this window and message handlers
// 
// refer to basic frame source to use this view window
//                                                                                   
// it has print and print-preview.
// you only need to override DrawScene() to show 3d objects.
// everything is done by this class.
// if you add some functions which is can be usef widely, edit this class
//
// Rotation, translation, picking
// You can override DrawScene() to draw what you want to show
// Also you can call MakeViewBox() to make a bounding box
// usage: 	CMultiDocTemplate* pDocTemplate;
// pDocTemplate = new CMultiDocTemplate(
//		IDR_POSTTYPE,
//		RUNTIME_CLASS(CPostDoc),
//		RUNTIME_CLASS(CPostFrame), // custom MDI child frame
//		RUNTIME_CLASS(CPostiew));
//  	AddDocTemplate(pDocTemplate);
// Replace CPostView with CGLView or CGLView-derived class
// You don't want to use template class, you had better make a client frame
// to use this class

#ifndef __CUBIC_POST_BASIC_GL_VIEW__
#define __CUBIC_POST_BASIC_GL_VIEW__

//preview..
#include <afxpriv.h> //for print preview 


#include "viewnode.h" // for view stack.. view loading, save..

#include <list> //stl

typedef list<int> CHOSEN_LIST; //chosen objects



class AFX_EXT_CLASS CGLView : public CView
{
public:
	// bitmap save (direct save. OpenGL backbuffer -> disk)
	void SaveBitmap(char* name) throw(char*);

	// color setting
	double m_dvBackColor[4]; //background color
	double m_dvTextColor[4]; //text color

	int m_bIsActive; // this view is active , for multiple views only, default false

	// VIEW NODE
#define MAX_VIEW_STACK 100
	double m_DegY; //screen camera
	double m_DegX; 
	ROT_VIEW m_Rot; //rotation(quaternion)
	double m_fLeft, m_fRight, m_fTop, m_fBottom; //clipping region
	double znear,zfar;  //distance of clipping place from zero point
	CViewNodes::iterator m_iViewStack; // iterator of this viewstack
	// view nodes list
	CViewNodes m_ViewStack; // view deque
	int PreviousView(void); // iterates..
	int NextView(void);
	void ReadViewNode(CViewNode& node);

	void PopView(void);
	void PushView(void);
	



	//boudning box
	double m_BoundX, m_BoundY, m_BoundZ; //bounding box
	double m_BoundR; //bounding sphere
	double m_dGridSize;


		//matrix store
	double m_dPro[16]; //projection matrix
	double m_dMod[16]; //modelview matrix
	int m_nVp[4]; //view port

	int m_nCursorID; //id of cursor to change the image of cursor
	bool m_bChangeCursor ; // change cursor or not

	HDC m_hDC; //device context
	HGLRC m_hRC; //rendering context for opengl 
	int m_bPrinting; //printing or not..

	


	double m_dViewX, m_dViewY; //viewport size
	int m_nViewX, m_nViewY; //viewport size.. just a integer form
	BOOL m_bPers; //perspective or isometric mode (Cad mode)

	
	double m_AspectRatio; //for correct screen 
	double m_Box; //size for viewvolume
	double m_projection[16]; // projection matrix for 3d picking

	
	double m_dScreenWidth; //for 2d 
	double m_dScreenHeight; 

	BOOL m_bPicking; //picking state ?
	
	//view manipulation
	CPoint m_OldPoint; //old point (for rotation and translation)
	BOOL m_bViewing; //is it viewing process (rotation or translation) just a mere status variable
	
	CRect m_rectZoom; //rectangle for section zoom
	CRect m_rectZoom2; // old rectZoom

	CGLView();
	DECLARE_DYNCREATE(CGLView)
	
	//draw bitmap text	
	// draw capture box
	void DrawCaptureBox(CRect box);

	static void glprintf(void* FONT, double x, double y,char* fmt, ...);
	static void glprintf(double x, double y,char* fmt, ...);
	//draw stroke font
	//static function so that it can accessed out of this class
	static void print2(int loc, double scale, double x, double y,double z,char* fmt, ...);
	//draw stroke text 
	void glprintf2(char* fmt, ...) ;
	int glGetWidth(char* fmt, ...);

    void KeepAspectRatio(double a); //kep asepct ratio
	void KeepAspectRatio(double& left, double& right,
							  double& bottom, double& top);

	virtual void SetViewVolume(); //view volume
	void SetLight(); //set light

	void MakeViewBox(double r); //rounding box


	HGLRC GetRC(void);
	int  SelectObject(int x, int y); //picking.. 
	//make a new boudning box 
	// x, y, z!
	virtual void SetBoundingBox(double sx, double sy, double sz);
	int IsCursorIdle(void); //is cursor idle, now?

	//draw grid lines
	void  DrawNet(double xsize, double zsize, double xstep, double zstep);
	//set material
	void  SetMaterial(double r, double g, double b);
	//draw axis
	static void DrawAxis(double height);
	static void DrawAxis2(double);
	static void DrawNet2(double xsize, double zsize, double xstep, double zstep,
		   double color[3], // small
					   double color2[3], // middle
					   double color3[3]); //big)
	// Printing
	BOOL m_bStretchBlt;
	BOOL m_bStretchDIBits;
	void GetCurrent(HDC& hDC, HGLRC& hRC) ;
	BOOL SetCurrent(HDC hDC, HGLRC hRC) ;
	BOOL SetMemDcPixelFormat(HDC hMemDC);

	// button control
	bool m_bLeftButton; // left button pressed?

	int SelectObjects(int sx, int sy,int ex,int ey, CHOSEN_LIST& List );


// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CGLView)
	public:
	virtual void OnDraw(CDC* pDC);  // overridden to draw this view
	virtual BOOL PreCreateWindow(CREATESTRUCT& cs);
	protected:
	virtual BOOL OnPreparePrinting(CPrintInfo* pInfo);
	virtual void OnBeginPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnEndPrinting(CDC* pDC, CPrintInfo* pInfo);
	virtual void OnPrint(CDC* pDC, CPrintInfo* pInfo);
	//}}AFX_VIRTUAL

// Implementation
public:
	void ActivateRC(void);
	void Draw2D(void);
	void GetMat(double Pro[16], double Mod[16]);
	void ConfirmRC(void);
	void ResetupData();
	
	void UpdateCenter(void);
	bool Get3D(int wx, int wy, double&,double&,double&,double Pro[16], double Mod[16]);

	// speed up background restore
	// real time game or simulation, don't use speed buffer
	// for large modeling management use speed buffer and
	// draw front buffer..
	int m_bSpeed; // true: use Speed Buffer, false: don't use speed buffer
	int m_bSpeedValid; // speed buffer is valid. LoadSpeed is valid!

	unsigned char* m_pSpeedBuffer;
	int m_nSpeedWidth; // speed buffer width
	int m_nSpeedHeight; // speed buffer height

	void InitSpeed(void); // one time initialize
	void ResizeSpeed(void);
	void SaveSpeed(void);
	void LoadSpeed(void);


	
	void ChangeCursor(int c);
	virtual ~CGLView();
#ifdef _DEBUG
	virtual void AssertValid() const;
	virtual void Dump(CDumpContext& dc) const;
#endif


// Generated message map functions
public:
	
	virtual void DrawScene(void);
	//{{AFX_MSG(CGLView)
	afx_msg int OnCreate(LPCREATESTRUCT lpCreateStruct);
	afx_msg void OnDestroy();
	afx_msg void OnSize(UINT nType, int cx, int cy);
	afx_msg void OnPaint();
	afx_msg BOOL OnEraseBkgnd(CDC* pDC);
	afx_msg void OnMouseMove(UINT nFlags, CPoint point);
	afx_msg void OnLButtonDown(UINT nFlags, CPoint point);
	afx_msg void OnLButtonUp(UINT nFlags, CPoint point);
	afx_msg void OnSetFocus(CWnd* pOldWnd);
	afx_msg void OnRButtonDown(UINT nFlags, CPoint point);
	virtual void OnViewExtents();
	afx_msg void OnViewPan();
	afx_msg void OnViewRotate();
	afx_msg void OnViewZoom();
	afx_msg void OnViewX();
	afx_msg void OnViewY();
	afx_msg void OnViewZ();
	afx_msg void OnViewSectionzoom();
	virtual void OnViewPers();
	afx_msg void OnUpdateViewPers(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewZoom(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewRotate(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewPan(CCmdUI* pCmdUI);
	afx_msg void OnUpdateViewSectionzoom(CCmdUI* pCmdUI);
	afx_msg BOOL OnSetCursor(CWnd* pWnd, UINT nHitTest, UINT message) ;
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


enum CURSOR_MODE {
	CURSOR_ARROW,
	CURSOR_WAIT,
	CURSOR_HELP,
	CURSOR_PAN,
	CURSOR_ZOOM,
	CURSOR_ROTATE,
	CURSOR_SECTIONZOOM
};



#endif 
