// Camera.cpp: implementation of the CCamera class.
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "Camera.h"
#include "math.h" // for mathematics..
#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

void DrawAxis(double height)
{
	double height2= height*0.5;
	double base=height2*0.1;
	
	//begin
	GLUquadricObj* obj=gluNewQuadric();
	gluQuadricDrawStyle(obj, GLU_FILL);
	gluQuadricNormals(obj,GLU_SMOOTH);

	glColor4d(1,1,0,0.8);
	glutSolidCube(base*2);

	//draw Z
	glColor4d(0,0,1,0.8);
	glPushMatrix();
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw Y
	glColor4d(0,1,0,0.8);
	glPushMatrix();
	glRotated(90, -1, 0, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();

	//draw X
	glColor4d(1,0,0,0.8);
	glPushMatrix();
	glRotated(90, 0, 1, 0);
	glTranslated(0,0,base);
	gluCylinder(obj,base,base, height, 4, 1); 
	glTranslated(0,0,height);
	gluCylinder(obj,base*2,0, height2, 4, 1); 
	glPopMatrix();


	gluDeleteQuadric(obj);
	//end

}

CCamera::CCamera()
{
	x=y=0;
	z=8;
	deg_y=0 ;
	deg_x=0;

	left=-3,right=3;
	bottom= -2,top=2;
	znear=8;
	zfar=500;

	ar=1; //aspect ratio


	m_bActive=FALSE; //Is the camera turned on? 
}

CCamera::~CCamera()
{

}

void CCamera::Show()
{

	double size=1;	                            
	glPushMatrix();

	glEnable(GL_BLEND);
	glBlendFunc (GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glDisable(GL_CULL_FACE);

	//ROTATE & MOVE
	glTranslated(x,y,z);
	glRotated(deg_y, 0, 1, 0);  // 0 ~ 360 degrees  : theta
	glRotated(deg_x, 1, 0, 0);	// -90 ~ 90 degrees : phi 

	DrawAxis(5);



	
	//DRAW VIEWVOLUME
	double left2,right2,top2,bottom2;
	left2= left* (zfar/znear);
	right2= right* (zfar/znear);
	top2= top*(zfar/znear);
	bottom2=bottom*(zfar/znear);

	//near clipping plane
	glColor4d(0,0,0.5, 0.5);
	glBegin(GL_POLYGON);
	glNormal3d(0,0,1);
	glVertex3d(left,top, -znear);
	glVertex3d(right,top, -znear);
	glVertex3d(right,bottom, -znear);
	glVertex3d(left,bottom ,-znear);
	glEnd();

	//far clipping plane
	/*glColor4d(0,0,0.5, 0.5);
	glBegin(GL_POLYGON);
	glNormal3d(0,0,1);
	glVertex3d(left2,top2, -zfar);
	glVertex3d(right2,top2, -zfar);
	glVertex3d(right2,bottom2, -zfar);
	glVertex3d(left2,bottom2 ,-zfar);
	glEnd();*/

	
	//the lines..
	glBegin(GL_LINES);
	glVertex3d(left,top, -znear); glVertex3d(left2, top2, -zfar); //LINE 1
	glVertex3d(right,top, -znear); glVertex3d(right2, top2, -zfar); //LINE 2
	glVertex3d(right,bottom, -znear); glVertex3d(right2, bottom2, -zfar); //LINE 3
	glVertex3d(left, bottom, -znear); glVertex3d(left2, bottom2, -zfar); //LINE 4
	glEnd();


	DrawAxis(size);

	auxSolidSphere(size/2.0);
	glPopMatrix();

	
	glDisable(GL_CULL_FACE);
	glDisable(GL_BLEND);
	glEnable(GL_DEPTH_TEST);

}

void CCamera::Activate(double projection[16])
{
	m_bActive=TRUE;

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	glFrustum(left, right, bottom, top, znear, zfar);
	glTranslated(0,0,0);

	glRotated(-deg_x, 1, 0, 0);
	glRotated(-deg_y, 0, 1, 0);
	glTranslated(-x,-y,-z);

	//set m_projection's value
	glGetDoublev(GL_PROJECTION_MATRIX, projection);

	glMatrixMode(GL_MODELVIEW);		
	glLoadIdentity();
}

BOOL CCamera::IsActive()
{
	return m_bActive;
}

void CCamera::Deactivate()
{
	m_bActive=FALSE;
}

void CCamera::SetAspectRatio(double AR)
{
	
	double height = top-bottom;
    double width =  height*AR;
	double cenx=(left+ right) / 2.;
	double ceny=(top+ bottom) /2.;

	//Ŭ   
	left=cenx - width/2.;
	right=cenx + width/2.;
	top = ceny + height/2.;
	bottom= ceny - height/2.; 

	ar=AR;
}

void CCamera::Move(double X, double Y, double Z, double DEG_Y, double DEG_X)
{
	x+=X, y+=Y, z+=Z;
	deg_y+= DEG_Y, deg_x += DEG_X;
}

//set the variables...
void CCamera::SetDeg(double DEG_Y, double DEG_X) 
{
	deg_y= DEG_Y, deg_x= DEG_X;
}

void CCamera::Set(double X, double Y, double Z, double DEG_Y, double DEG_X,
				  double LEFT, double RIGHT, double BOTTOM, double TOP)
{
	x=X, y=Y, z=Z;
	deg_x = DEG_X, deg_y = DEG_Y;

	left=LEFT, right=RIGHT, bottom=BOTTOM, top=TOP;
	
	//aspect ratio compensation
	double height = top-bottom;
    double width =  height*ar;
	double cenx=(left+ right) / 2.;
	double ceny=(top+ bottom) /2.;

	//Ŭ   
	left=cenx - width/2.;
	right=cenx + width/2.;
	top = ceny + height/2.;
	bottom= ceny - height/2.; 
}

//add the variables...
void CCamera::Add(double X, double Y, double Z, double DEG_Y, double DEG_X)
{
	x+=X, y+=Y, z+=Z;
	deg_x += DEG_X, deg_y += DEG_Y;
}

//get variables..
void CCamera::Get(double* X, double* Y, double* Z, double* DEG_Y, double* DEG_X)
{
	*X= x, *Y= y, *Z= z;
	*DEG_Y= deg_y, *DEG_X= deg_x;
}

//ī޶  Ѵ 
void CCamera::AddMove(CMove a)
{
	m_MoveQueue.push(a);
}

//QUEUE óѴ 
BOOL CCamera::ProcessQueue()
{
	
	// ť ä ִ°?
	if (m_MoveQueue.empty()==TRUE) return FALSE;
	
	//ť óѴ ( Ѱ ̻ ó 尡 ִ)
	CMove& m=m_MoveQueue.front(); 
	
	if (m.IsStart()) {   // .. ⼭   ϸ̼ Ѵ 
		m.SetStart(x,y,z,deg_y,deg_x,left,right,bottom,top);
	}

	m.Animate(); //ī޶ δ 
	m.Get(&x, &y, &z, &deg_y, &deg_x,
		&left, &right, &bottom, &top);

	if (m.IsOver()) {  // 
		m_MoveQueue.pop(); //ڵ ó . 带  
	} 
	
	
	
	
	
	return TRUE;
}

char* CCamera::ShowData()
{
	static char buffer[500];
	static char tmp[500];
	/*sprintf(buffer,"// x , y, z, deg_y, deg_x\n"
		"%lf , %lf , %lf , %lf , %lf \n"
		"//left, right, bottom, top\n"
		"%lf , %lf , %lf , %lf\n",
		 x, y, z, deg_y, deg_x,
		left, right, bottom, top);*/

	//start
	buffer[0]= NULL;

/*	sprintf(tmp, 
	"m_Camera.AddMove(CMove(%lf, %lf, %lf, %lf, %lf, \n"
	"%lf, %lf, %lf, %lf));\n ",
	x, y, z, deg_y, deg_x,
	left, right, bottom, top);
	strcat(buffer,tmp);*/
	
	//adjust degrees
	int dy= (int)deg_y%360;
	int dx= (int)deg_x%360;
	if (dy>180) dy -= 360;
	if (dx>180) dx -= 360;

	//update..
	deg_y=(double)dy;
	deg_x=(double)dx;

	sprintf(tmp, 
	"m_Camera.AddMove(CMove(%lf, %lf, %lf, %lf, %lf, \n"
	"%lf, %lf, %lf, %lf));\n ",
	x, y, z, deg_y, deg_x,
	left, right, bottom, top);
	strcat(buffer,tmp);



	FILE* f=fopen("d:\\log\\camera2.txt","at");
	if (f) {
		fprintf(f,buffer);
		fclose(f);
	}
	return buffer;
}

//Ȯ  
void CCamera::Scale(double s)
{
	double height=top- bottom;
	double width= right- left;
	
	double cenx= (left + right ) / 2.0 ;
	double ceny= (bottom + top) / 2.0;

	//scale!!
	height *=s;
	width *=s;

	//adjust..
	left= cenx - width / 2.0;
	right = cenx + width / 2.0;
	bottom = ceny - height / 2.0 ;
	top = ceny + height / 2.0 ;
}


//move to the front
void CCamera::Proceed(double R)
{
	double r=R;
	double dx,dz;
	double rad= (deg_y + 90)  / 180.0 * 3.14159;
	
	dx=r*cos(rad);
	dz=-r*sin(rad);

	x+=dx, z+=dz;

}

//move back 
void CCamera::Retreat(double R)
{
	double r=-R;
	double dx,dz;
	double rad= (deg_y+90) / 180.0 * 3.14159;

	dx=r*cos(rad);
	dz=-r*sin(rad);
	
	x+=dx, z+=dz;
}
