// Camera.h: interface for the CCamera class.
//
//////////////////////////////////////////////////////////////////////

#if !defined(AFX_CAMERA_H__5E2107E3_C219_11D2_957B_525405DFB27B__INCLUDED_)
#define AFX_CAMERA_H__5E2107E3_C219_11D2_957B_525405DFB27B__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "move.h"
#include <queue>

using namespace std;


class AFX_EXT_CLASS CCamera  
{
protected:
	double m_projection[16];
	//    
	// Z   ----> Z DIRECTION == EYE DIRECTION
	//
	//
	double x,y,z;
	double deg_x, deg_y;

	double left,right,top,bottom; //clipping plane
	double znear,zfar; //distance

	double ar; //asepct ratio

	BOOL m_bActive;

	queue<CMove> m_MoveQueue; //how can we move ? 

public:
	void Retreat(double R);
	void Proceed(double R);
	void Scale(double s);
	char* ShowData(void);
	BOOL ProcessQueue(void);
	void AddMove(CMove a);
	void Add(double X=0, double Y=0, double Z=0, double DEG_Y=0, double DEG_X=0);
	void Get(double* X, double* Y, double* Z, double* DEG_Y, double* DEG_X);
	void SetDeg(double DEG_Y=0, double DEG_X=0) ;
	void Set(double X=0, double Y=0, double Z=0, double DEG_Y=0, double DEG_X=0,
		double LEFT=-2, double RIGHT=2, double BOTTOM=-2, double TOP=2);

	void Move(double X=0, double Y=0, double Z=0, double DEG_Y=0, double DEG_X=0);
	void SetAspectRatio(double AR);
	void Deactivate(void);
	BOOL IsActive(void);
	void Activate(double projection[16]);
	void Show(void);
	CCamera();
	virtual ~CCamera();

};

#endif // !defined(AFX_CAMERA_H__5E2107E3_C219_11D2_957B_525405DFB27B__INCLUDED_)
