// GLDlg.cpp : implementation file
//

#include "stdafx.h"
#include "GLDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CGLDlg dialog


CGLDlg::CGLDlg(int IDD,CWnd* pParent /*=NULL*/)
	: CDialog(IDD, pParent)
{
	//{{AFX_DATA_INIT(CGLDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
		
	m_dDegX=40;
	m_dDegY=40;

	MakeViewBox(50);
}
	

void CGLDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CGLDlg)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CGLDlg, CDialog)
	//{{AFX_MSG_MAP(CGLDlg)
	ON_WM_CREATE()
	ON_WM_SIZE()
	ON_WM_PAINT()
	ON_WM_DESTROY()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CGLDlg message handlers

int CGLDlg::OnCreate(LPCREATESTRUCT lpCreateStruct) 
{
	if (CDialog::OnCreate(lpCreateStruct) == -1)
		return -1;
	
	HWND hWnd = GetSafeHwnd();
	HDC hDC = GetDC()->GetSafeHdc();

	if(SetWindowPixelFormat(hDC)==FALSE)
		return 0;
	
	if(CreateViewGLContext(hDC)==FALSE)
		return 0;

	COLORREF color = ::GetSysColor(COLOR_3DFACE);
	glClearColor((float)GetRValue(color)/255.0f,
				 (float)GetGValue(color)/255.0f,
				 (float)GetBValue(color)/255.0f,
				 1.0);

	glPolygonMode(GL_FRONT,GL_FILL);
	glPolygonMode(GL_BACK,GL_FILL);

  glShadeModel(GL_SMOOTH);

	return 0;
}

void CGLDlg::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);
	
	// make current
	wglMakeCurrent(GetDC()->GetSafeHdc(), m_hGLContext);

	glDrawBuffer(GL_FRONT_AND_BACK); // <- bug fixed
    glViewport(0,0,cx,cy);
	glDrawBuffer(GL_BACK);


	GLsizei width,height;
	GLdouble aspect;

	width = cx;
	height = cy;

	if(cy==0)
		aspect = (GLdouble)width;
	else
		aspect = (GLdouble)width/(GLdouble)height;
	KeepAspectRatio(aspect);


	SetViewVolume();

	glDrawBuffer(GL_BACK);
	glEnable(GL_LIGHTING);
	glEnable(GL_DEPTH_TEST);

    glEnable(GL_NORMALIZE);
	glPolygonMode(GL_FRONT_AND_BACK, GL_FILL);
	glEnable(GL_CULL_FACE);
	
}

void CGLDlg::OnPaint() 
{
	
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CPaintDC dc(this); // device context for painting
		wglMakeCurrent(dc.GetSafeHdc(), m_hGLContext);
		glDrawBuffer(GL_BACK);
		RenderScene();
		SwapBuffers(dc.m_ps.hdc);
	//	CDialog::OnPaint();

	}
}

void CGLDlg::OnDestroy() 
{
	CDialog::OnDestroy();


	if(wglGetCurrentContext() != NULL)
		wglMakeCurrent(NULL,NULL);

	if(m_hGLContext != NULL)
	{
		wglDeleteContext(m_hGLContext);
		m_hGLContext = NULL;
	}
	
	
}


void CGLDlg::MakeViewBox(double r)
{
	 //3d mode
	m_dLeft=-r; //dummy value
	m_dRight=r;
	m_dTop=r/4.0;//important
	m_dBottom=-r/4.0;
	m_dZNear=r; // 0 Ҽ ٰ  
	m_dZFar=r*100;

	m_dBox=r; // r    ִ 3   
}


void CGLDlg::SetViewVolume()
{
	//in case, there exist many OpenGL windows
	//this code should work
//	wglMakeCurrent(m_hDC, m_hRC);	

	//projection mode
    glMatrixMode(GL_PROJECTION);
    glLoadIdentity();
	glFrustum(m_dLeft, m_dRight, m_dBottom, m_dTop, m_dZNear, m_dZFar);

	glTranslated(0,0,-m_dZNear-m_dBox*2);
	//copy projection matrix for 3d picking..
	glGetDoublev(GL_PROJECTION_MATRIX, m_dvPro);

    //model view mode
    glMatrixMode(GL_MODELVIEW);
    glLoadIdentity();
}

void CGLDlg::KeepAspectRatio(double a) 
{
	//3d
	double height = m_dTop-m_dBottom;
    double width =  height*a; //control width from height
	double cenx=(m_dLeft+ m_dRight) / 2.;
	double ceny=(m_dTop+ m_dBottom) /2.;

	//Ŭ   
	m_dLeft=cenx - width/2.;
	m_dRight=cenx + width/2.;
	m_dTop = ceny + height/2.;
	m_dBottom= ceny - height/2.; 

	m_dAR=a;
}


void CGLDlg::SetLight()
{
	// Set the material color to follow the current color
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	//glColorMaterial(GL_FRONT_AND_BACK, GL_SPECULAR);
	//glMateriali(GL_FRONT_AND_BACK, GL_SHININESS, 100);
	glEnable(GL_COLOR_MATERIAL);


	float ambient[] = { 0.0, 0.0, 0.0, 0.0 };
	float diffuse[] = { 1.0, 1.0, 1.0, 0.0 };
    float specular[] = { 1.0, 1.0, 1.0, 0.0 };

    float position[] = { 10, 10, 10,  0 };
    float lmodel_ambient[] = { 0.7f, 0.7f, 0.7f, 0.0f };
    float local_view[] = { 0.0 };

    glEnable(GL_DEPTH_TEST);

    glLightfv(GL_LIGHT0, GL_AMBIENT, ambient);
    glLightfv(GL_LIGHT0, GL_DIFFUSE, diffuse);
    glLightfv(GL_LIGHT0, GL_POSITION, position);
    glLightModelfv(GL_LIGHT_MODEL_AMBIENT, lmodel_ambient);
    glLightModelfv(GL_LIGHT_MODEL_LOCAL_VIEWER, local_view);

   
    glEnable(GL_LIGHT0);
	glDisable(GL_LIGHT1);
	glDisable(GL_LIGHT2);
	glDisable(GL_LIGHT3);
	glDisable(GL_LIGHT4);
	glDisable(GL_LIGHT5);
	glDisable(GL_LIGHT6);	
	glDisable(GL_LIGHT7);
	glEnable(GL_LIGHTING);
}





BOOL CGLDlg::SetWindowPixelFormat(HDC hDC)
{
	PIXELFORMATDESCRIPTOR pixelDesc;

	pixelDesc.nSize = sizeof(PIXELFORMATDESCRIPTOR);
	pixelDesc.nVersion = 1;

	pixelDesc.dwFlags = PFD_DRAW_TO_WINDOW | 
						PFD_SUPPORT_OPENGL |
						PFD_DOUBLEBUFFER |
						PFD_STEREO_DONTCARE;

	pixelDesc.iPixelType = PFD_TYPE_RGBA;
	pixelDesc.cColorBits = 32;
	pixelDesc.cRedBits = 8;
	pixelDesc.cRedShift = 16;
	pixelDesc.cGreenBits = 8;
	pixelDesc.cGreenShift = 8;
	pixelDesc.cBlueBits = 8;
	pixelDesc.cBlueShift = 0;
	pixelDesc.cAlphaBits = 0;
	pixelDesc.cAlphaShift = 0;
	pixelDesc.cAccumBits = 64;
	pixelDesc.cAccumRedBits = 16;
	pixelDesc.cAccumGreenBits = 16;
	pixelDesc.cAccumBlueBits = 16;
	pixelDesc.cAccumAlphaBits = 0;
	pixelDesc.cDepthBits = 32;
	pixelDesc.cStencilBits = 8;
	pixelDesc.cAuxBuffers = 0;
	pixelDesc.iLayerType = PFD_MAIN_PLANE;
	pixelDesc.bReserved = 0;
	pixelDesc.dwLayerMask = 0;
	pixelDesc.dwVisibleMask = 0;
	pixelDesc.dwDamageMask = 0;

	m_GLPixelIndex = ChoosePixelFormat(hDC,&pixelDesc);
	if(m_GLPixelIndex==0) // Choose default
	{
		m_GLPixelIndex = 1;
		if(DescribePixelFormat(hDC,m_GLPixelIndex,
			sizeof(PIXELFORMATDESCRIPTOR),&pixelDesc)==0)
		{
			return FALSE;
		}
	}

	if(SetPixelFormat(hDC,m_GLPixelIndex,&pixelDesc)==FALSE)
	{
		return FALSE;
	}

	return TRUE;
}


BOOL CGLDlg::CreateViewGLContext(HDC hDC)
{
	m_hGLContext = wglCreateContext(hDC);

	if(m_hGLContext==NULL)
		return FALSE;

	if(wglMakeCurrent(hDC,m_hGLContext)==FALSE)
		return FALSE;



	return TRUE;
}

void CGLDlg::RenderScene()
{
		glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

	glPushMatrix();

	SetLight();

	glColor3d(1,0.8,0);
	glutSolidSphere(10,20,20);

	glPopMatrix();

}

