/****************************************************************************************/
/*  ARRAY.H                                                                             */
/*                                                                                      */
/*  Author:                                                                             */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
#ifndef JE_ARRAY_H
#define JE_ARRAY_H

#include "BaseType.h"
#include "VFile.h"

#ifdef __cplusplus
extern "C" {
#endif

//-----------------------------------------------------------------------
// types

typedef struct jeArray 				jeArray;
typedef uint32 						jeArray_Index;
typedef struct jeArray_Defragmenter	jeArray_Defragmenter;

#define jeArray_MaxIndex			((jeArray_Index)((~ ((jeArray_Index)0) )-1))

#define JE_ARRAY_NULL_INDEX			(jeArray_MaxIndex+1)

typedef jeBoolean (* jeArray_IOFunc) (jeVFile * File,void * Element,void *Context);

//-----------------------------------------------------------------------
// protos

extern jeArray *		jeArray_Create(int HunkLength,int NumHunks,int AutoExtendNumItems);
extern void 			jeArray_CreateRef(		jeArray * Array);
extern void 			jeArray_Destroy(		jeArray ** pArray);
extern jeBoolean		jeArray_Extend(			jeArray * Array,int NumHunks);
extern void				jeArray_Reset(			jeArray * Array);

extern void *			jeArray_GetNewElement(	jeArray * Array);
extern jeBoolean		jeArray_FreeElement(	jeArray * Array,void * Element);
	
extern jeArray_Index	JETCC jeArray_GetElementIndex(void * Element);
							// == (ArrayPtr - Array)/sizeof(Item)
extern void *			JETCC jeArray_GetElement(jeArray * Array,jeArray_Index Index);
							// == Array[Index]

extern void *			JETCC jeArray_GetNextElement(jeArray * Array,void * H);
							// use NULL to get it started

jeArray_Index JETCC jeArray_GetNextIndex(jeArray * Array, jeArray_Index Index);
							// use JE_ARRAY_NULL_INDEX to get it started

extern jeArray_Defragmenter * 	jeArray_DefragmentStart(jeArray * Array);
extern jeArray_Index			jeArray_Defragment(		jeArray_Defragmenter * D, jeArray_Index I);
extern void 					jeArray_DefragmentEnd(	jeArray_Defragmenter * D);

extern jeArray *		JETCC jeArray_CreateFromFile(jeVFile * File,jeArray_IOFunc ElementReader,void *ReaderContext);
extern jeBoolean		JETCC jeArray_WriteToFile(const jeArray * Array,jeVFile * File,jeArray_IOFunc ElementWriter,void *WriterContext);
							// you should _Defragment before you WriteToFile if you can !!!!

//-----------------------------------------------------------------------
// docs

/**********

Degfrag sample code:

void DoMyDefrag(jeArray * A)
{
jeArray_Defragmenter * D;

	D = jeArray_DefragmentStart(A);
	assert(D);

	while( I have stuff )
	{
		// remap an Index
		MyIndex = jeArray_GetElementIndex(MyData->Pointer);
		jeArray_Defragment(D, & MyIndex );
		MyData->Index = MyIndex;
	}

	jeArray_DefragmentDone(D);

	while ( I have stuff )
	{
		MyData->Pointer = jeArray_GetElement(A,MyData->Index);
	}

}

***********/

#ifdef __cplusplus
}
#endif

#endif /* JE_POOL_H */

