/****************************************************************************************/
/*  JEMATERIAL.H                                                                        */
/*                                                                                      */
/*  Author:  John Pollard                                                               */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/

#ifndef JE_MATERIAL_H
#define JE_MATERIAL_H

#include "jeTypes.h"
#include "Array.h"
#include "Bitmap.h"
#include "VFile.h"
#include "jePtrMgr.h"

#ifdef __cplusplus
extern "C" {
#endif

//=======================================================================================
//	
//=======================================================================================
typedef struct							jeMaterial			jeMaterial;
typedef struct							jeMaterial_Array	jeMaterial_Array;	

typedef jeArray_Index					jeMaterial_ArrayIndex;

#define JE_MATERIAL_ARRAY_NULL_INDEX	JE_ARRAY_NULL_INDEX

#define JE_MATERIAL_MAX_NAME_SIZE		256

//=======================================================================================
//	Function prototypes
//=======================================================================================
JETAPI void					jeMaterial_Destroy(jeMaterial **Material);
JETAPI jeBoolean			jeMaterial_CreateRef(jeMaterial *Material);
JETAPI jeMaterial			*jeMaterial_Create(const char *MatName);
JETAPI jeBoolean			jeMaterial_SetBitmap(jeMaterial *Mat, jeBitmap *Bitmap, const char *BitmapName);
JETAPI const jeBitmap		*jeMaterial_GetBitmap(const jeMaterial *Mat);
JETAPI const char			*jeMaterial_GetName( const jeMaterial *Mat);

JETAPI jeMaterial_Array		*jeMaterial_ArrayCreate(int32 StartMaterials);
JETAPI jeMaterial_Array		*jeMaterial_ArrayCreateFromFile(jeVFile *VFile, jePtrMgr *PtrMgr);
JETAPI jeBoolean			jeMaterial_ArrayWriteToFile(jeMaterial_Array *MatArray, jeVFile *VFile, jePtrMgr *PtrMgr);
JETAPI jeBoolean			jeMaterial_ArrayCreateRef(jeMaterial_Array *MatArray);
JETAPI void					jeMaterial_ArrayDestroy(jeMaterial_Array **Array);
JETAPI jeMaterial_ArrayIndex jeMaterial_ArrayCreateMaterial(jeMaterial_Array *MatArray, const char *MatName);
JETAPI void					jeMaterial_ArrayDestroyMaterial(jeMaterial_Array *MatArray, jeMaterial_ArrayIndex *Index);
JETAPI const				jeMaterial *jeMaterial_ArrayGetMaterialByIndex(const jeMaterial_Array *Array, jeMaterial_ArrayIndex Index);
JETAPI jeMaterial_ArrayIndex jeMaterial_ArrayGetMaterialIndex(const jeMaterial_Array *Array, const jeMaterial *Material);
JETAPI jeBoolean			jeMaterial_ArraySetMaterialBitmap(jeMaterial_Array *Array, jeMaterial_ArrayIndex Index, jeBitmap *Bitmap, const char *BitmapName);
JETAPI jeMaterial			*jeMaterial_ArrayGetNextMaterial(jeMaterial_Array *Array, const jeMaterial *Start);
#ifdef __cplusplus
}
#endif

#endif
