// SetupDlg.cpp : implementation file
//

#include "stdafx.h"
#include "Setup.h"
#include "SetupDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CAboutDlg)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

// Implementation
protected:
	//{{AFX_MSG(CAboutDlg)
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg dialog

CSetupDlg::CSetupDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CSetupDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CSetupDlg)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	// Note that LoadIcon does not require a subsequent DestroyIcon in Win32
	m_hIcon = AfxGetApp()->LoadIcon(IDI_ICON1);
}

void CSetupDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CSetupDlg)
	DDX_Control(pDX, IDCANCEL, m_cancel);
	DDX_Control(pDX, IDC_APPLY, m_apply);
	DDX_Control(pDX, IDOK, m_ok);
	DDX_Control(pDX, IDC_LEVEL, m_level);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CSetupDlg, CDialog)
	//{{AFX_MSG_MAP(CSetupDlg)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BROWSE, OnBrowse)
	ON_BN_CLICKED(IDC_APPLY, OnApply)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CSetupDlg message handlers

BOOL CSetupDlg::OnInitDialog()
{
 bool	lb_valid;
 char	lc_temp[255];

 // Init.
 lb_valid = false;


	CDialog::OnInitDialog();

	// Add "About..." menu item to system menu.

	// IDM_ABOUTBOX must be in the system command range.
	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		CString strAboutMenu;
		strAboutMenu.LoadString(IDS_ABOUTBOX);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	// Set the icon for this dialog.  The framework does this automatically
	//  when the application's main window is not a dialog
	SetIcon(m_hIcon, TRUE);			// Set big icon
	SetIcon(m_hIcon, FALSE);		// Set small icon
	
 // See if we already have valid ini settings for the combos.
 GetPrivateProfileString("GENERAL", "VALID", "NO", lc_temp, 255, "jminiapp.ini");
 if(strcmp(lc_temp, "YES") == 0)
  lb_valid = true;

 if(lb_valid) 
 {
  GetPrivateProfileString("GENERAL", "LEVEL", "NONE", lc_temp, 255, "jminiapp.ini");
  if(strcmp(lc_temp, "NONE") != 0)
  {
   m_level.SetWindowText(lc_temp);
  }
 }

	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CSetupDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialog::OnSysCommand(nID, lParam);
	}
}

// If you add a minimize button to your dialog, you will need the code below
//  to draw the icon.  For MFC applications using the document/view model,
//  this is automatically done for you by the framework.

void CSetupDlg::OnPaint() 
{
	if (IsIconic())
	{
		CPaintDC dc(this); // device context for painting

		SendMessage(WM_ICONERASEBKGND, (WPARAM) dc.GetSafeHdc(), 0);

		// Center icon in client rectangle
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// Draw the icon
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialog::OnPaint();
	}
}

// The system calls this to obtain the cursor to display while the user drags
//  the minimized window.
HCURSOR CSetupDlg::OnQueryDragIcon()
{
	return (HCURSOR) m_hIcon;
}

void CSetupDlg::OnBrowse() 
{
// This will launch a find file dialog to allow the user to browse to a level.
 // if a level was selected the level and the path are saved to the registry.
 CFileDialog	*cfile;
 char			ls_filter[] = "Jet World Files (*.j3d)|*.j3d||"; 
 CString		ls_buffer;
 char			lc_temp[255];



 // If we alread have a level store, default to that directory.
 m_level.GetWindowText(lc_temp, 255);
 
 if(strcmp(lc_temp, "None selected") != 0)
 {
  m_level.GetWindowText(lc_temp, 255);
  // strip off level name to leave path
  for(int i=strlen(lc_temp)-1; i>0; i--)
  {
   if(lc_temp[i]=='\\')
   {
    lc_temp[i]=0;
    break;
   }
  }
  
   SetCurrentDirectory(lc_temp);
 }

 cfile = new CFileDialog(true, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT,
	                     ls_filter);
	 
 
 if(cfile->DoModal() == IDOK)
 {
  ls_buffer = cfile->GetPathName();
  m_level.SetWindowText(cfile->GetPathName()); 


  m_cancel.EnableWindow();
  m_apply.EnableWindow();
 }

 delete cfile;
	
}

void CSetupDlg::OnApply() 
{
 // Save the current level.
 char	lc_temp[255];

 m_level.GetWindowText(lc_temp, 255);
 WritePrivateProfileString("GENERAL", "LEVEL", lc_temp, "jminiapp.ini");

 // We now have some valid settings.
 WritePrivateProfileString("GENERAL", "VALID", "YES", "jminiapp.ini");


 m_cancel.EnableWindow(false);	// You can't cancel until you change something!
}

void CSetupDlg::WinHelp(DWORD dwData, UINT nCmd) 
{
 CAboutDlg dlgAbout;
 dlgAbout.DoModal();
 
 //CDialog::WinHelp(dwData, nCmd);	
}

void CSetupDlg::OnOK() 
{
 char	lc_temp[255];
 
 m_level.GetWindowText(lc_temp, 255);
 WritePrivateProfileString("GENERAL", "LEVEL", lc_temp, "jminiapp.ini");

 // We now have some valid settings.
 WritePrivateProfileString("GENERAL", "VALID", "YES", "jminiapp.ini");
 

 CDialog::OnOK();
}
