// Jet3d - JMiniApp
// Filename:camera_manager.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/



#include "jmini_app.h"


/*****************************************************************************/
/*                             PROCESSING FUNCTIONS							 */
/*****************************************************************************/








/******************************************************************************/
/*									INTERFACE FUNCTIONS		                  */
/******************************************************************************/
CameraManager::CameraManager(void)
{
 ib_initialized = false;
 camera = NULL;
 if_accelMove = if_accelRotate = 0;
 ib_moveForwards = ib_moveBackwards = ib_turnLeft = ib_turnRight = false;
}

CameraManager::~CameraManager(void)
{
 if(camera)
  jeCamera_Destroy(&camera);
}


/*----------------------------------------------------------------------------
  Name:		Initialize(FuncResult funcResult)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void
CameraManager::Initialize(FuncResult *funcResult)
{
 jeRect		CameraRect;
 long		ll_width, ll_height;
 float		lf_camPosX, lf_camPosY, lf_camPosZ;
 jeXForm3d	xForm;
 

 if(ib_initialized)
 {
  funcResult->SetError(FUNCR_OBJECTALREADYINITIALIZED, __LINE__, __FILE__);
  goto ReturnOut;
 }

 
 worldManager->renderManager->GetWidthAndHeight(funcResult, ll_width, ll_height);
 if(funcResult->GetFailed())
  goto ReturnOut;

 // setup camera rect
 CameraRect.Left = 0;
 CameraRect.Right = ll_width - 1;
 CameraRect.Top = 0;
 CameraRect.Bottom = ll_height - 1;

 // create camera
 camera = jeCamera_Create(2.0f, &CameraRect);
 if(!camera)
 {
  funcResult->SetError("Camera create failed", __LINE__, __FILE__);
  goto ReturnOut;
 }

 jeCamera_SetAttributes(camera, 2.0f, &CameraRect);


 jeXForm3d_SetIdentity(&xForm);
 
 // set default location
 lf_camPosX = 0;
 lf_camPosY = 16;
 lf_camPosZ = 200;
 
 jeXForm3d_Translate(&xForm, lf_camPosX, lf_camPosY, lf_camPosZ);
 
 jeCamera_SetXForm(camera, &xForm);
 
 // Camera movement.
 if_accelMove = 300.0f;
 if_accelRotate = 2.0f;
 
 // Ok.
 ib_initialized = true;


ReturnOut:
 // All errors are init errors.
 if(funcResult->GetFailed())
  funcResult->SetInitError();

 return;
}

/*----------------------------------------------------------------------------
  Name:		DoSomething(float af_deltaTime)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void	
CameraManager::DoSomething(float af_deltaTime)
{
 jeVec3d	In, Pos;
 jeXForm3d	xForm;
 float		lf_temp;

 jeCamera_GetXForm(camera, &xForm);


 jeXForm3d_GetIn(&xForm, &In);

 


 if(ib_turnRight)
 {
  // Calculate acceleration amount.
  lf_temp = (if_accelRotate * af_deltaTime);

  // do that funky math
  jeVec3d_Copy( &(xForm.Translation ), &Pos );
  jeVec3d_Set( &(xForm.Translation ), 0.0f, 0.0f, 0.0f );
  jeXForm3d_RotateY(&xForm, -lf_temp);
  jeXForm3d_Translate( &xForm, Pos.X, Pos.Y, Pos.Z);
 }

 if(ib_turnLeft)
 {
  // Calculate acceleration amount.
  lf_temp = (if_accelRotate * af_deltaTime);
	
  jeVec3d_Copy( &(xForm.Translation ), &Pos );
  jeVec3d_Set( &(xForm.Translation ), 0.0f, 0.0f, 0.0f );
  jeXForm3d_RotateY(&xForm, lf_temp);
  jeXForm3d_Translate( &xForm, Pos.X, Pos.Y, Pos.Z);
 }


 if(ib_moveForwards)
 {
  // Calculate acceleration amount.
  lf_temp = (if_accelMove * af_deltaTime);
	
  jeVec3d_AddScaled( &( xForm.Translation ), &In, lf_temp, &( xForm.Translation ) );
 }


 if(ib_moveBackwards)
 {
  // Calculate acceleration amount.
  lf_temp = (if_accelMove * af_deltaTime);
	
  jeVec3d_AddScaled( &( xForm.Translation ), &In, -lf_temp, &( xForm.Translation ) );
 }

 // Update our camera with the updated matrix.
 jeCamera_SetXForm(camera, &xForm);
}


