// Jet3d - JMiniApp
// Filename:camera_manager.h
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

/*****************************************************************************/
/*                             COMMON VERSION                                 */
/*****************************************************************************/

#ifndef __CAMERA_MANAGER_H
#define __CAMERA_MANAGER_H

class CameraManager 
{
 private:
  /*****************************************************************************/
  /*                             MEMBER DATA                                   */
  /*****************************************************************************/
  bool					ib_initialized;
  
  // This represents wants the player (in this case the camera) wants to do.
  bool					ib_turnLeft, ib_turnRight;
  bool					ib_moveForwards, ib_moveBackwards;	 


  
  // How many movement units the player increases/decreases per time unit, 
  // this will be linear.
  float					if_accelMove; 
  float					if_accelRotate;

  
  
  /*****************************************************************************/
  /*                             PROCESSING FUNCTIONS                          */
  /*****************************************************************************/ 
  
  
 


 public:
  /*****************************************************************************/
  /*									INTERFACE OBJECTS 	      			   */
  /*****************************************************************************/ 
  jeCamera				*camera;
  

 
  /*****************************************************************************/
  /*									INTERFACE FUNCTIONS		      		   */
  /*****************************************************************************/
  CameraManager(void);
  ~CameraManager(void);

 
    
  bool			GetInitialized(void)
  {
	return ib_initialized;
  }

  void			Initialize(FuncResult *funcResult);

  void		TurnLeft(bool ab_switch)
  {
   if(ab_switch)
   {
    if(!ib_turnRight)
	 ib_turnLeft = true;
   }
   else
    ib_turnLeft = false;
  }

  void		TurnRight(bool ab_switch)
  {
   if(ab_switch)
   {
    if(!ib_turnLeft)
	 ib_turnRight = true;
   }
   else
    ib_turnRight = false;
  }
  
  void			MoveForwards(bool ab_switch)
  {
   if(ab_switch)
   {
    if(!ib_moveBackwards)
	 ib_moveForwards = true;
   }
   else
    ib_moveForwards = false;
  }

  void			MoveBackwards(bool ab_switch)
  {
   if(ab_switch)
   {
    if(!ib_moveForwards)
	 ib_moveBackwards = true;
   }
   else
    ib_moveBackwards = false;
  }

  void			DoSomething(float af_deltaTime);
  
};



#endif //#define __CAMERA_MANAGER_HPP
