// Jet3d - JMiniApp
// Filename:driver_list.h
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/





#ifndef __DRIVER_LIST_H
#define __DRIVER_LIST_H




class DriverList
{
 private:
  /*****************************************************************************/
  /*                             MEMBER DATA                                   */
  /*****************************************************************************/
  DriverInfo					*m_pDrvListHead; 
  bool							ib_initialized;

  /*****************************************************************************/
  /*                             PROCESSING FUNCTIONS                          */
  /*****************************************************************************/ 
  ModeInfo		*GetModes(FuncResult *funcResult, jeDriver *driver, int ai_filter);  
  DriverInfo    *FindCurrentDriver(FuncResult *funcResult);
  ModeInfo		*FindCurrentMode(FuncResult *funcResult, DriverInfo &drvInfo);




 public:
  /*****************************************************************************/
  /*							 INTERFACE FUNCTIONS      		      		   */
  /*****************************************************************************/
	 
  DriverList(void);
  ~DriverList(void);

  // Build the driver (and mode) list.
  void			Initialize(FuncResult *funcResult, int ai_filter);
   
  bool			GetInitialized(void)
  {
   return ib_initialized;
  } 
	
  
  void			SelectDriver(FuncResult *funcResult, char *ac_drvName);
  void			SelectDefaultDriver(FuncResult *funcResult);

#ifndef _DEBUG
  // Set the current mode for the current driver (there must therefore be a current driver).
  void			SelectMode(FuncResult *funcResult, char *ac_modeName);
#endif


  // Set the current mode for the current driver (there must therefore be a current driver).
  void			SelectDefaultMode(FuncResult *funcResult);
  
  
  char			*GetCurrentDriverName(FuncResult *funcResult);
  char			*GetCurrentModeName(FuncResult *funcResult);
  jeDriver		*GetCurrentDriver(FuncResult *funcResult);
  jeDriver_Mode		*GetCurrentMode(FuncResult *funcResult);

  void			Release(void);
  
 
};



#endif

