// Jet3d - JMiniApp
// Filename:driver_list_d.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/

/*****************************************************************************/
/*                             DEBUG VERSION                                 */
/*****************************************************************************/

#include "jmini_app.h"




/*****************************************************************************/
/*                             PROCESSING FUNCTIONS                          */
/*****************************************************************************/ 






/*****************************************************************************/
/*									INTERFACE FUNCTIONS		      		     */
/*****************************************************************************/
 
/*----------------------------------------------------------------------------
  Name:		SelectDefaultMode(FuncResult *funcResult)
  Purpose:	Set the current mode for the current driver 
			(there must therefore be a current driver).
  Notes:	The default mode will always be the first (and only) mode when running in debug.   

  1.  
----------------------------------------------------------------------------*/
void			
DriverList::SelectDefaultMode(FuncResult *funcResult)
{
 DriverInfo		*tempDrvInfo;
 ModeInfo		*tempModeInfo;
 bool			lb_found;


 // Init,
 funcResult->SetUndef();
 tempDrvInfo = NULL;
 tempModeInfo = NULL; 
 lb_found = false;

 tempDrvInfo = m_pDrvListHead;
 
 while(tempDrvInfo)
 {
  if(tempDrvInfo->ib_current)
  {
   lb_found = true;
   break;
  }

  tempDrvInfo = tempDrvInfo->nextDriver;
 }

 
 if(!lb_found)
 {
  funcResult->SetError("Could not find the current driver", __LINE__, __FILE__);
  goto ReturnOut;
 }


 tempModeInfo = tempDrvInfo->imodeInfo;
 
 // Unselect any previous current mode.
 while(tempModeInfo)
 {
  if(tempModeInfo->ib_current)
  {
   tempModeInfo->ib_current = false;
   break; // Should only ever be one current mode.
  }

  tempModeInfo = tempModeInfo->nextMode;
 }
 
 

 

 // Ok.
 tempDrvInfo->imodeInfo->ib_current = true; // Set the default mode.
 funcResult->SetOk();


ReturnOut:
 return;
}
