// Jet3d - JMiniApp
// Filename:driver_list_r.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/

/*****************************************************************************/
/*                             RELEASE VERSION                               */
/*****************************************************************************/


#include "jmini_app.h"




/*****************************************************************************/
/*                             PROCESSING FUNCTIONS                          */
/*****************************************************************************/ 






/*****************************************************************************/
/*									INTERFACE FUNCTIONS		      		     */
/*****************************************************************************/


/*----------------------------------------------------------------------------
  Name:		SelectMode(FuncResult *funcResult, char *ac_modeName)
  Purpose:	Set the current mode for the current driver
  Notes:	There must be a current driver.    

  1.  
----------------------------------------------------------------------------*/
void			
DriverList::SelectMode(FuncResult *funcResult, char *ac_modeName)
{
 DriverInfo		*tempDrvInfo;
 ModeInfo		*tempModeInfo;
 bool			lb_found;

 // Check args.
 if(!ac_modeName)
 {
  funcResult->SetError(FUNCR_INVAILDARGS, __LINE__, __FILE__);
  goto ReturnOut;
 }
 
 // Init,
 funcResult->SetUndef();
 tempDrvInfo = NULL;
 tempModeInfo = NULL; 
 lb_found = false;
 

 if(!ib_initialized)
 {
  funcResult->SetError(FUNCR_OBJECTNOTINITIALIZED, __LINE__, __FILE__);
  goto ReturnOut;
 } 


 tempDrvInfo = FindCurrentDriver(funcResult);
 if(funcResult->GetFailed())
  goto ReturnOut;

 tempModeInfo = tempDrvInfo->imodeInfo;

  // Unselect any previous current mode.
 while(tempModeInfo)
 {
  if(tempModeInfo->ib_current)
  {
   tempModeInfo->ib_current = false;
   break; // Should only ever be one current mode.
  }

  tempModeInfo = tempModeInfo->nextMode;
 }
 
 
 // Set the specified mode.
 tempModeInfo = tempDrvInfo->imodeInfo;
 
 while(tempModeInfo)
 {
  if(strcmp(tempModeInfo->ic_modeName, ac_modeName) == 0)
  {
   tempModeInfo->ib_current = true;
   lb_found = true;
   break; 
  }

  tempModeInfo = tempModeInfo->nextMode;
 }

 if(!lb_found)
 {
  funcResult->SetError("Unknown mode specified", __LINE__, __FILE__);
  goto ReturnOut;
 }



 // Ok.
 funcResult->SetOk();


ReturnOut:
 return;
}


/*----------------------------------------------------------------------------
  Name:		SelectDefaultMode(FuncResult *funcResult)
  Purpose:	Set the current mode for the current driver 
  Notes:    There must be a current driver.  

  1.  
----------------------------------------------------------------------------*/
void			
DriverList::SelectDefaultMode(FuncResult *funcResult)
{
 DriverInfo		*tempDrvInfo;
 ModeInfo		*tempModeInfo;
 bool			lb_found;


 // Init,
 funcResult->SetUndef();
 tempDrvInfo = NULL;
 tempModeInfo = NULL; 
 lb_found = false;


 tempDrvInfo = FindCurrentDriver(funcResult);
 if(funcResult->GetFailed())
  goto ReturnOut;

 tempModeInfo = tempDrvInfo->imodeInfo;
 

 // Unselect any previous current mode.
 while(tempModeInfo)
 {
  if(tempModeInfo->ib_current)
  {
   tempModeInfo->ib_current = false;
   break; // Should only ever be one current mode.
  }

  tempModeInfo = tempModeInfo->nextMode;
 }
 
 
 // Set the default mode.
 
 // Try for the first default.
 lb_found = false; // Reset.
 tempModeInfo = tempDrvInfo->imodeInfo;
 
 while(tempModeInfo)
 {
  if(strcmp(tempModeInfo->ic_modeName, DEFAULT_MODE_ONE) == 0)
  {
   tempModeInfo->ib_current = true;
   lb_found = true;
   break; 
  }

  tempModeInfo = tempModeInfo->nextMode;
 }

 if(!lb_found)
 {
  // Try for the second default.
  lb_found = false; // Reset.
  tempModeInfo = tempDrvInfo->imodeInfo;
 
  while(tempModeInfo)
  {
   if(strcmp(tempModeInfo->ic_modeName, DEFAULT_MODE_TWO) == 0)
   {
    tempModeInfo->ib_current = true;
    lb_found = true;
    break; 
   }

   tempModeInfo = tempModeInfo->nextMode;
  }
 }

 if(!lb_found)
 {
  funcResult->SetError("Could not select a default mode for the current driver", __LINE__, __FILE__);
  goto ReturnOut;
 }
 


 // Ok.
 funcResult->SetOk();


ReturnOut:
 return;
}
