// Jet3d - JMiniApp
// Filename:error_manager.h
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/

/*****************************************************************************/
/*                            COMMON VERSION                                 */
/*****************************************************************************/


#ifndef __ERROR_MANAGER_H
#define __ERROR_MANAGER_H

class ErrorManager
{
 private:
  /*****************************************************************************/
  /*                             MEMBER DATA                                   */
  /*****************************************************************************/
  bool			ib_logging; 
  HANDLE		fileHandle;	

  
  
  enum LogMessageType
  {
   INIT_ERROR,
   RUNTIME_ERROR,
   NON_ERROR
  };




  

  /*****************************************************************************/
  /*                             PROCESSING FUNCTIONS                          */
  /*****************************************************************************/ 
  void			GetTextForID(HRESULT ahr_id, char *ac_error);
  void			GetDxString(FuncResult *ahr_result, DWORD adw_msg, char *ac_msg);
  void			LogError(FuncResult *ahr_result, const FuncResult *ahr_errorInfo);
  void			LogMessage(FuncResult *ahr_result, char *ac_msg, LogMessageType logMsgType);
  void			WriteToLog(FuncResult *ahr_result, char *ac_msg); 

 public:
  /*****************************************************************************/
  /*							 INTERFACE FUNCTIONS      		      		   */
  /*****************************************************************************/
	 
   ErrorManager(void);
  ~ErrorManager(void);

  bool			GetLogging(void)
  {
   return ib_logging;
  }

  void			StartLogging(FuncResult *ahr_result);
  void			StopLogging(FuncResult *ahr_result);

  void			FatalError(FuncResult *errorInfo); 
    
 
  HRESULT		Log(char *ac_txt); 
  HRESULT		Log(char *ac_txt, char *ac_txt2); 
  HRESULT		Log(char *ac_txt, char *ac_txt2, char *ac_txt3); 
  
};




#endif