// Jet3d - JMiniApp
// Filename:func_result.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/

/*****************************************************************************/
/*                            COMMON VERSION                                 */
/*****************************************************************************/

#include "jmini_app.h"


/*****************************************************************************/
/*                             PROCESSING FUNCTIONS                          */
/*****************************************************************************/ 





/*****************************************************************************/
/*									INTERFACE FUNCTIONS		      		     */
/*****************************************************************************/
FuncResult::FuncResult(void)
{
 ib_used = false;
 ihr_msgId = FUNCR_UNDEFRESULT;
 ib_initError = false;
 ic_errorFileString = ic_userTxt = NULL;
 ii_lineNum = 0;
}

FuncResult::~FuncResult(void)
{
 if(ic_userTxt)
 {
  delete ic_userTxt;
  ic_userTxt = NULL;
 }

 if(ic_errorFileString)
 {
  delete ic_errorFileString;
  ic_errorFileString = NULL;
 }
}

/*----------------------------------------------------------------------------
  Name:		SetError(int ai_lineNum, char *ac_errorFileString) 
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT
FuncResult::SetError(int ai_lineNum, char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 // Just specify that a general error occured.
 ihr_msgId = FUNCR_GENERAL;
 
 
 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 }

 
 ii_lineNum = ai_lineNum;

 ihr_msgId = FUNCR_GENERAL; // DEFAULT.


 // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;


ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		SetError(HRESULT ahr_errId, int ai_lineNum, char *ac_errorFileString) 
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT
FuncResult::SetError(HRESULT ahr_errId, int ai_lineNum, char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 
 
 
 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 }

 
 ihr_msgId = ahr_errId;
 ii_lineNum = ai_lineNum;
 

 // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;


ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		SetError(char *ac_userTxt, int ai_lineNum, char *ac_errorFileString)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT	
FuncResult::SetError(char *ac_userTxt, int ai_lineNum, char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 if(ac_userTxt)
 {
  if(!ic_userTxt)
  ic_userTxt = new char[MAX_ERROR_TXT];
  
  strcpy(ic_userTxt, ac_userTxt);
 } 

 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 } 
 
 ii_lineNum = ai_lineNum; 

 ihr_msgId = FUNCR_GENERAL; // DEFAULT.


 // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;
 

ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		SetError(char *ac_userTxt, char *ac_userTxt2, int ai_lineNum, 
                     char *ac_errorFileString)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT	
FuncResult::SetError(char *ac_userTxt, char *ac_userTxt2, int ai_lineNum, 
					 char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 if(ac_userTxt)
 {
  if(!ic_userTxt)
  ic_userTxt = new char[MAX_ERROR_TXT];
  
  strcpy(ic_userTxt, ac_userTxt);

  if(ac_userTxt2)
   strcpy(ic_userTxt, ac_userTxt2);
 } 

 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 } 
 
 ii_lineNum = ai_lineNum; 

 ihr_msgId = FUNCR_GENERAL; // DEFAULT.
  
  // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;
 

ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		SetError(char *ac_userTxt, char *ac_userTxt2, char *ac_userTxt3, int ai_lineNum, 
                     char *ac_errorFileString)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT	
FuncResult::SetError(char *ac_userTxt, char *ac_userTxt2, char *ac_userTxt3, 
					 int ai_lineNum, char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 if(ac_userTxt)
 {
  if(!ic_userTxt)
   ic_userTxt = new char[MAX_ERROR_TXT];
  
  strcpy(ic_userTxt, ac_userTxt);

  if(ac_userTxt2)
   strcpy(ic_userTxt, ac_userTxt2);

  if(ac_userTxt3)
   strcpy(ic_userTxt, ac_userTxt3);
 } 

 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 } 
 

 ii_lineNum = ai_lineNum; 

 ihr_msgId = FUNCR_GENERAL; // DEFAULT.


 // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;
 

ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		SetError(HRESULT ahr_errId, char *ac_userTxt, int ai_lineNum, 
                     char *ac_errorFileString)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT	
FuncResult::SetError(HRESULT ahr_errId, char *ac_userTxt, int ai_lineNum, char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 if(ac_userTxt)
 {
  if(!ic_userTxt)
   ic_userTxt = new char[MAX_ERROR_TXT];
  
  strcpy(ic_userTxt, ac_userTxt);
 } 

 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 } 
 

 ihr_msgId = ahr_errId;
 ii_lineNum = ai_lineNum; 
 

 // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;
 

ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		SetError(HRESULT ahr_errId, char *ac_userTxt, char *ac_userTxt2, int ai_lineNum, 
                     char *ac_errorFileString)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT	
FuncResult::SetError(HRESULT ahr_errId, char *ac_userTxt, char *ac_userTxt2, 
					 int ai_lineNum, char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 if(ac_userTxt)
 {
  if(!ic_userTxt)
   ic_userTxt = new char[MAX_ERROR_TXT];
  
  strcpy(ic_userTxt, ac_userTxt);

  if(ac_userTxt2)
   strcpy(ic_userTxt, ac_userTxt2);
 } 

 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 } 
 
 ihr_msgId = ahr_errId;
 ii_lineNum = ai_lineNum; 
 

 // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;
 

ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		SetError(HRESULT ahr_errId, char *ac_userTxt, char *ac_userTxt2, char *ac_userTxt3, 
                     int ai_lineNum, char *ac_errorFileString)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
HRESULT	
FuncResult::SetError(HRESULT ahr_errId, char *ac_userTxt, char *ac_userTxt2, char *ac_userTxt3, 
					 int ai_lineNum, char *ac_errorFileString) 
{
 HRESULT		lhr_result;


 if(ib_used)
 {
  lhr_result = FUNCR_VALUEALREADYSTORED;
  goto ReturnOut;
 }

 if(ac_userTxt)
 {
  if(!ic_userTxt)
   ic_userTxt = new char[MAX_ERROR_TXT];
  
  strcpy(ic_userTxt, ac_userTxt);

  if(ac_userTxt2)
   strcpy(ic_userTxt, ac_userTxt2);

  if(ac_userTxt3)
   strcpy(ic_userTxt, ac_userTxt3);
 } 

 if(ac_errorFileString)
 {
  if(!ic_errorFileString)
   ic_errorFileString = new char[MAX_ERROR_TXT];

  strcpy(ic_errorFileString, ac_errorFileString);
 } 
 

 ihr_msgId = ahr_errId;
 ii_lineNum = ai_lineNum; 
 

 // Ok.
 ib_used = true;
 lhr_result = FUNCR_OK;
 

ReturnOut:
 return lhr_result;
}

/*----------------------------------------------------------------------------
  Name:		Reset(void)
  Purpose:	Returns this object to it's default state, ready to be used again.
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void		
FuncResult::Reset(void)
{
 if(ic_userTxt)
 {
  delete ic_userTxt;
  ic_userTxt = NULL;
 }

 if(ic_errorFileString)
 {
  delete ic_errorFileString;
  ic_errorFileString = NULL;
 }

 ib_used = false;
 ihr_msgId = FUNCR_UNDEFRESULT;
 ib_initError = false;
 ic_errorFileString = ic_userTxt = NULL;
 ii_lineNum = 0;
}

