// Jet3d - JMiniApp
// Filename:func_result.h
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/
#ifndef __FUNC_RESULT_H
#define __FUNC_RESULT_H


// Forward declaration.
class ErrorManager;

class FuncResult
{
 friend class ErrorManager;

 private:
  bool			ib_used;
  HRESULT		ihr_msgId;
  bool			ib_initError;
  char			*ic_userTxt;
  char			*ic_errorFileString;
  int			ii_lineNum;

  /*****************************************************************************/
  /*                             PROCESSING FUNCTIONS                          */
  /*****************************************************************************/ 




 public:
  /*****************************************************************************/
  /*									INTERFACE FUNCTIONS		      		   */
  /*****************************************************************************/ 

  FuncResult(void);

  ~FuncResult(void);


  void	SetInitError(void)
  {
   ib_initError = true;
  }

  bool	GetInitError(void) const
  {
   return ib_initError;
  }
  
 
  HRESULT	SetError(int ai_lineNum = 0, char *ac_errorFileString = NULL); 
  
  HRESULT	SetError(HRESULT ahr_errId, int ai_lineNum = 0, char *ac_errorFileString = NULL); 

  HRESULT	SetError(char *ac_userTxt, int ai_lineNum = 0,
	                 char *ac_errorFileString = NULL);

  HRESULT	SetError(char *ac_userTxt, char *ac_userTxt2,
	                 int ai_lineNum = 0, char *ac_errorFileString = NULL);

  HRESULT	SetError(char *ac_userTxt, char *ac_userTxt2,  char *ac_userTxt3,
	                 int ai_lineNum = 0, char *ac_errorFileString = NULL);

  HRESULT	SetError(HRESULT ahr_errId, char *ac_userTxt, int ai_lineNum = 0,
	                 char *ac_errorFileString = NULL);

  HRESULT	SetError(HRESULT ahr_errId, char *ac_userTxt, char *ac_userTxt2,
	                 int ai_lineNum = 0, char *ac_errorFileString = NULL);

  HRESULT	SetError(HRESULT ahr_errId, char *ac_userTxt, char *ac_userTxt3,
	                 char *ac_userTxt2, int ai_lineNum = 0, char *ac_errorFileString = NULL);



  HRESULT	SetOk(void)
  {
   if(!ib_used)
   {
	ihr_msgId = FUNCR_OK;
	return FUNCR_OK;
   }
   else
    return FUNCR_VALUEALREADYSTORED;
  }

  HRESULT	SetUndef(void)
  {
   if(!ib_used)
   {
	ihr_msgId = FUNCR_UNDEFRESULT;
	return FUNCR_OK;
   }
   else
    return FUNCR_VALUEALREADYSTORED;
  }
  
  bool	GetFailed(void)
  {
   if(FAILED(ihr_msgId))
	 return true;
   else
	 return false;
  }

  void		Reset(void);

};

#endif


