// Jet3d - JMiniApp
// Filename:jet_win.c
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/

                                            
/*****************************************************************************/
/*                            COMMON VERSION                                 */
/*****************************************************************************/


#include "jmini_app.h"






// Global worldManager pointer.
WorldManager		*worldManager;






/*----------------------------------------------------------------------------
  Name:		WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance, LPSTR lpCmdLine,
                    int nCmdShow)
  Purpose:	Initialization, message loop.
  Notes:      

  1.  
----------------------------------------------------------------------------*/
int PASCAL 
WinMain(HINSTANCE hInstance,HINSTANCE hPrevInstance, LPSTR lpCmdLine,int nCmdShow)
{
 MSG         msg;
 FuncResult	 funcResult;

 // Init.
 worldManager = NULL;


 	
 // Create our worldManager manager (global pointer).
 worldManager = new WorldManager;


 // Did we successfully create the World Manager.
 if(!worldManager)
  return 0;

 worldManager->InitializeWin(&funcResult, hInstance, nCmdShow);
 if(funcResult.GetFailed())
 {
  // This was an init error but we cannot report it because the Error Manager hasn't
  // been created yet!
  // And we can't even display error txt, because we haven't got a window!
  delete worldManager;
  worldManager = NULL;
  return 0;
 }
 
 worldManager->InitializeWorld(&funcResult); 
 if(funcResult.GetFailed())
 {
  if(worldManager->errorManager)
  {
   worldManager->errorManager->FatalError(&funcResult);
  }
  else
  {
   // Can't use the Error Manager to display the actual error text!
   worldManager->QuitWithError("Cannot display error text, no Error Manager created", true);
  }

  delete worldManager;
  worldManager = NULL;
  return 0;
 }


 while(TRUE)
 {
  if(PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
  {
   if(msg.message == WM_QUIT) 
   {
    if(worldManager)
    {
     delete worldManager;  // Delete our global pointer (this object should then clean-up).
     worldManager = NULL;
    } 

	return msg.wParam; // Break the loop!
   }

   TranslateMessage(&msg);
   DispatchMessage(&msg);
  } 
  else 
  {
   if(gi_appActive)
    worldManager->UpdateWorld();
  }
 }
} 


