// Jet3d - JMiniApp
// Filename:jet_win_d.c
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/

                                            
/*****************************************************************************/
/*                             DEBUG VERSION                                 */
/*****************************************************************************/


#include "jmini_app.h"



// Is application active?    
int			gi_appActive = FALSE;		
		
// Is the application minimized?
bool		gb_appMinimized = false;

// The user has made a request to terminate the app.
bool		ib_userQuit = false;




/*----------------------------------------------------------------------------
  Name:		WindowProc(HWND hWnd,UINT message, WPARAM wParam, LPARAM lParam)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
long FAR PASCAL 
WindowProc(HWND hWnd,UINT message, WPARAM wParam, LPARAM lParam)
{
 bool		lb_defProc;
 long		ll_result;
 
 // Let Windows process this message by default.
 lb_defProc = true;
 ll_result = 0;


 
 switch(message)
 {
  case WM_ACTIVATE:
   switch(LOWORD(wParam))
   {
	 case WA_INACTIVE:
	  gi_appActive = FALSE;
	  if(!gb_appMinimized)
	  {
	   // If the window is not minimized, it must have lost focus,
	   // so trigger a WM_PAINT (this will then display a paused message).
	   InvalidateRect(hWnd, NULL, true); 
	  }
     break;

	 default:
	  if(!gb_appMinimized)
	  {	  
	   // The window must now be active and maximized.
	   gi_appActive = TRUE;
     }
	  break;
	}	
	lb_defProc = false;
    ll_result = 0;
   	break;
         
  case WM_CREATE:
   lb_defProc = false;
   ll_result = 0;
	break;
   
  case WM_PAINT:
   if((!gi_appActive) && (!gb_appMinimized))  
   {
    // Paint "Game Paused" in the middle of the screen
    PAINTSTRUCT	ps;
    HDC				hdc;
	
    hdc = BeginPaint(hWnd, &ps);

    worldManager->DisplayMessage("PAUSED");
    
	EndPaint(hWnd, &ps);

    ll_result = 0;
    lb_defProc = false;
   }
   break;

  case WM_KEYDOWN:
   switch(wParam)
   {
    case VK_LEFT:
	  worldManager->TurnLeft(true);
	  ll_result = 0;
      lb_defProc = false;
	  break;
   
    case VK_RIGHT:
	  worldManager->TurnRight(true);
	  ll_result = 0;
      lb_defProc  = false;
	  break; 
	
	case VK_UP:
	  worldManager->MoveForwards(true);
	  ll_result = 0;
      lb_defProc = false;
	  break;  
				
    case VK_DOWN:
	  worldManager->MoveBackwards(true);
	  ll_result = 0;
      lb_defProc = false;
	  break;  
	               
	 case VK_TAB:
	  worldManager->SetShowStats();
	  ll_result = 0;
	  lb_defProc = false;
	  break;
	 
	 case VK_ESCAPE:
      ib_userQuit = true;
      DestroyWindow(hWnd);
	  ll_result = 0;
      lb_defProc = false;
     break;
   }
   break;

  case WM_KEYUP:
   switch(wParam)
   {
    case VK_LEFT:
	  worldManager->TurnLeft(false);
	  ll_result = 0;
      lb_defProc = false;
	  break;
   
    case VK_RIGHT:
	  worldManager->TurnRight(false);
	  ll_result = 0;
      lb_defProc  = false;
	  break; 
	
	case VK_UP:
	  worldManager->MoveForwards(false);
	  ll_result = 0;
      lb_defProc = false;
	  break;  
				
    case VK_DOWN:
	  worldManager->MoveBackwards(false);
	  ll_result = 0;
      lb_defProc = false;
	  break;  	 
   }	               
   break;

  
  
  case WM_MOVE:
  	RECT	rcWindow;
	POINT	pWindow;
	 
	// Get the client (drawing) rectangle.
	GetClientRect(hWnd, &rcWindow);
	
	pWindow.x = rcWindow.left;
	pWindow.y = rcWindow.top;

	// Convert the coordinates from client relative.
	ClientToScreen(hWnd, &pWindow);

	// Update Render Manager with new position.
	//worldManager->SetClientPos(pWindow);
   
   ll_result = 0;
   lb_defProc = false;
   break;

  case WM_SIZE:
   // Our window size is fixed, so this could only be a minimize or maximize.
   if(wParam == SIZE_MINIMIZED) 
   {
    gi_appActive = FALSE;
    gb_appMinimized = true;
   }
   else
   {
    gi_appActive = TRUE;
    gb_appMinimized = false;
   }
   ll_result = 0;
   lb_defProc = false;
   break;

  case WM_DESTROY:
   // Indicate to Windows that this thread has made a request to terminate.
   
   // See if we are quitting because an error occured.
   if(ib_userQuit)
    PostQuitMessage(1);
   else
	 PostQuitMessage(-1); // Must have been an error.

   ll_result = 0;
   lb_defProc = false;
   break;
 }
 

 if(lb_defProc)
  return DefWindowProc(hWnd, message, wParam, lParam);
 else
  return ll_result;
}  



