// Jet3d - JMiniApp
// Filename:jet_win_r.c


                                            
/*****************************************************************************/
/*                            RELEASE VERSION                                */
/*****************************************************************************/



#include "jmini_app.h"


// Is application active?    
int			gi_appActive = FALSE;		
		
// Is the application minimized?
bool		gb_appMinimized = false;

// The user has made a request to terminate the app.
bool		ib_userQuit = false;



/*----------------------------------------------------------------------------
  Name:		WindowProc(HWND hWnd,UINT message, WPARAM wParam, LPARAM lParam)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
long FAR PASCAL 
WindowProc(HWND hWnd,UINT message, WPARAM wParam, LPARAM lParam)
{
 bool		lb_defProc;
 long		ll_result;
 
 // Let Windows process this message by default.
 lb_defProc = true;
 ll_result = 0;


 
 switch(message)
 {
  case WM_ACTIVATE:
   switch(LOWORD(wParam))
   {
	 case WA_INACTIVE:
	  gi_appActive = FALSE;
	  if(!gb_appMinimized)
	  {
	   // If the window is not minimized, it must have lost focus,
	   // so trigger a WM_PAINT (this will then display a paused message).
	   InvalidateRect(hWnd, NULL, true); 
	  }
     break;

	 default:
	  if(!gb_appMinimized)
	  {	  
	   // The window must now be active and maximized.
	   gi_appActive = TRUE;
     }
	  break;
	}	
	lb_defProc = false;
    ll_result = 0;
   	break;
         
  case WM_CREATE:
   lb_defProc = false;
   ll_result = 0;
	break;
   

  case WM_KEYDOWN:
   switch(wParam)
   {
    case VK_LEFT:
	  worldManager->TurnLeft(true);
	  ll_result = 0;
      lb_defProc = false;
	  break;
   
    case VK_RIGHT:
	  worldManager->TurnRight(true);
	  ll_result = 0;
      lb_defProc  = false;
	  break; 
	
	case VK_UP:
	  worldManager->MoveForwards(true);
	  ll_result = 0;
      lb_defProc = false;
	  break;  
				
    case VK_DOWN:
	  worldManager->MoveBackwards(true);
	  ll_result = 0;
      lb_defProc = false;
	  break;  
     
	case VK_TAB:
	  worldManager->SetShowStats();
	  ll_result = 0;
	  lb_defProc = false;
	  break;
	 
	 case VK_ESCAPE:
      ib_userQuit = true;
      DestroyWindow(hWnd);
	  ll_result = 0;
      lb_defProc = false;
     break;
   }
   break;

  case WM_KEYUP:
   switch(wParam)
   {
    case VK_LEFT:
	  worldManager->TurnLeft(false);
	  ll_result = 0;
      lb_defProc = false;
	  break;
   
    case VK_RIGHT:
	  worldManager->TurnRight(false);
	  ll_result = 0;
      lb_defProc  = false;
	  break; 
	
	case VK_UP:
	  worldManager->MoveForwards(false);
	  ll_result = 0;
      lb_defProc = false;
	  break;  
				
    case VK_DOWN:
	  worldManager->MoveBackwards(false);
	  ll_result = 0;
      lb_defProc = false;
	  break;   
	}	               
   break;
  
  
  case WM_DESTROY:
   // Indicate to Windows that this thread has made a request to terminate.
   
   // See if we are quitting because an error occured.
   if(ib_userQuit)
    PostQuitMessage(1);
   else
	 PostQuitMessage(-1); // Must have been an error.

   ll_result = 0;
   lb_defProc = false;
   break;
 }
 

 if(lb_defProc)
  return DefWindowProc(hWnd, message, wParam, lParam);
 else
  return ll_result;
}  



