// Jet3d - JMiniApp
// Filename:jlevel.h
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/


#ifndef __JLEVEL_H
#define __JLEVEL_H




class JLevel
{
 
 private:
		bool			ib_initialized;

		
		jeResourceMgr	*resourceMgr;
		jePtrMgr		*ptrMgr;

	

		//Directories
		char			ic_exeBaseDir[MAX_PATH];
		char			ic_objectDir[MAX_PATH];			//default: Objects


		char			ic_levelBaseDir[MAX_PATH];
		char			ic_materialDir[MAX_PATH];			//default: GlobalMaterials
		char			ic_actorDir[MAX_PATH];				//default: Actors
		char			ic_soundDir[MAX_PATH];				//default: Sounds
		char			ic_levelDir[MAX_PATH];				//default: Levels
		
		jeVFile			*materialVFile;
		jeVFile			*actorVFile;
		jeVFile			*soundVFile;
		jeVFile			*levelVFile;


	

		//Sound objects
		jeSound_System  *soundSys;
		



	
  
  /*****************************************************************************/
  /*                             PROCESSING FUNCTIONS                          */
  /*****************************************************************************/ 
  void InitFileSystem(FuncResult *funcResult);
  

 public:
  /*****************************************************************************/
  /*									INTERFACE FUNCTIONS		      		   */
  /*****************************************************************************/ 

  JLevel(void);
  ~JLevel(void);


  void				Initialize(FuncResult *funcResult, char *ac_levelBase);
  jeWorld			*Load(FuncResult *funcResult, char *ac_levelPath);
  
  
  
};

#endif


