// Jet3d - JMiniApp
// Filename: jmini_app.h
// Main header file for JMiniApp.
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/
#ifndef __JMINI_APP_H
#define __JMINI_APP_H



// Standard header files.
#include <windows.h>
#include <mmsystem.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include <math.h>



// Jet3d specific.
#include "jet.h"
#include "bitmap.h"
#include "Errorlog.h"
#include "jePtrMgr.h"
#include "jeResource.h"
#include "jeversion.h"




// Need this for HRESULT.
#include <objbase.h>




#define _FACDD  0x876
#define MAKE_DDHRESULT( code )  MAKE_HRESULT( 1, _FACDD, code )






// Application specific errors.

// General.
#define	FUNCR_OK							0 // Same as DD_OK.
#define FUNCR_GENERAL						MAKE_DDHRESULT(10010)
#define FUNCR_UNDEFRESULT					MAKE_DDHRESULT(10050)
#define FUNCR_OBJECTNOTCREATED				MAKE_DDHRESULT(10100)
#define FUNCR_INTERFACENOTCREATED			MAKE_DDHRESULT(10120)
#define FUNCR_NOTIMPLEMENTED				MAKE_DDHRESULT(10500)
#define FUNCR_BITMAPLOADFAILED				MAKE_DDHRESULT(10600)
#define FUNCR_COULDNOTALLOCMEM				MAKE_DDHRESULT(10700)
#define FUNCR_OBJECTNOTINITIALIZED			MAKE_DDHRESULT(10800)
#define FUNCR_OBJECTALREADYINITIALIZED		MAKE_DDHRESULT(10810)
#define FUNCR_UNKNOWNOBJECTTYPE				MAKE_DDHRESULT(10840)
#define FUNCR_INVAILDARGS					MAKE_DDHRESULT(10900)
#define FUNCR_OUTOFARRAYSPACE				MAKE_DDHRESULT(10920)
#define FUNCR_COULDNOTFINDELEMENT			MAKE_DDHRESULT(10940)
#define FUNCR_SERVICENOTRUNNING				MAKE_DDHRESULT(10960)
#define FUNCR_SERVICEALREADYRUNNING			MAKE_DDHRESULT(10980)



// World Manager defines.



// Error Manager.
#define FUNCR_VALUEALREADYSTORED			MAKE_DDHRESULT(11000)
#define FUNCR_VALUENOTSTORED				MAKE_DDHRESULT(11010)
#define MAX_DXVERSION_STRING				5
#define MAX_ERROR_TXT						255
#define LOG_FILE_DIR						"Logs"
#define MAX_LOG_MSG							512


// Render Manager.
#define FUNCR_NOTATREQUIREDDXLEVEL			MAKE_DDHRESULT(12000)
#define REQUIRED_DX							0x700 // At least DirectX 7 must be installed.
#define MAX_DRV_NAME						255
#define MAX_MODE_NAME						255

#ifdef _DEBUG
 #define DRVLIST_FILTER						DRVLIST_SOFTWARE | DRVLIST_WINDOW
#else
 #define DRVLIST_FILTER						DRVLIST_HARDWARE | DRVLIST_FULLSCREEN
#endif
	
		
// Registry Manager.




 






/*****************************Misc defines********************/
#define	NOVA_LOGGING						false

#ifdef	_DEBUG
 // Always log if running in debug!
 #undef NOVA_LOGGING
 #define NOVA_LOGGING						true
#endif


#define	MAX_SMALL_STRING					64
#define	MAX_NORMAL_STRING					128
#define	MAX_LARGE_STRING					255
	

// Current version.
#define NOVA_VERSION_MAJOR					1
#define NOVA_VERSION_MINOR1					0
#define NOVA_VERSION_MINOR2					0


#define FUNCR_INVALIDINISETTINGS			MAKE_DDHRESULT(16000)


#ifdef _DEBUG
 // Direct Draw mode.
 #define SCREEN_HORZ_RES 640
 #define SCREEN_VERT_RES 480
#endif


// Default screen modes.
#define DEFAULT_MODE_ONE					"640x480x16"
#define DEFAULT_MODE_TWO					"640x480x8"

/* VK_A thru VK_Z are the same as ASCII 'A' thru 'Z' (0x41 - 0x5A) */
#define VK_A 0x41
#define VK_Z 0x5A


// Used to filter drivers/modes.
#define DRVLIST_WINDOW		( 1 << 0 )
#define DRVLIST_FULLSCREEN	( 1 << 1 )
#define DRVLIST_SOFTWARE	( 1 << 2 )
#define DRVLIST_HARDWARE	( 1 << 3 )
#define DRVLIST_ALL			( 1 << 4 )






// JMiniApp specific headers.
#include "resource.h"
#include "func_result.h"
#include "error_manager.h"
#include "driver_info.h"
#include "mode_info.h"
#include "driver_list.h"
#include "render_manager.h"
#include "camera_manager.h"
#include "jlevel.h"
#include "world_manager.h"











// Function prototypes.
long FAR PASCAL WindowProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam);
void			GetDXVersion(LPDWORD pdwDXVersion);
bool			GetAppPath(char  *ac_pathBuf, int ai_buffSize);





/*****************Externals************************/

// Our one global pointer.
extern WorldManager		*worldManager;


// Has there been a fatal error.
extern bool			gb_fatalError;

// Is the application active.			
extern int			gi_appActive;





#endif		// #define __JMINI_APP_H