// Jet3d - JMiniApp
// Filename:render_manager.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/


/*****************************************************************************/
/*                             COMMON VERSION                                */
/*****************************************************************************/
 


#include "jmini_app.h"


/*****************************************************************************/
/*                      PROCESSING FUNCTIONS								 */
/*****************************************************************************/








/******************************************************************************/
/*									INTERFACE FUNCTIONS		                  */
/******************************************************************************/
RenderManager::RenderManager(void)
{
 ib_initialized = false;
 m_pDrvList = NULL;
}

RenderManager::~RenderManager(void)
{
 if(m_pDrvList)
 {
  delete m_pDrvList;
  m_pDrvList = NULL;
 }
}


/*----------------------------------------------------------------------------
  Name:		Initialize(FuncResult *funcResult)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void
RenderManager::Initialize(FuncResult *funcResult)
{
 DWORD			ldw_version;
 int			li_dmFilter;
 jeDriver		*tempDrv;
 jeDriver_Mode	*tempMode;
  
   
  
 // Init.
 funcResult->SetUndef();
 tempDrv = NULL;
 tempMode = NULL;
 li_dmFilter = DRVLIST_FILTER; 


 

 if(ib_initialized)
 {
  funcResult->SetError(FUNCR_OBJECTALREADYINITIALIZED, __LINE__, __FILE__);
  goto ReturnOut;
 }



 // Make sure we are running at least the required version of DirectX.
 GetDXVersion(&ldw_version);

 if(ldw_version < REQUIRED_DX)
 {
  funcResult->SetError(FUNCR_NOTATREQUIREDDXLEVEL, __LINE__, __FILE__); 
  goto ReturnOut;
 }


 // Build a list of valid drivers with their respected modes for this client machine.
 m_pDrvList = new DriverList();
 if(!m_pDrvList)
 {
  funcResult->SetError(FUNCR_COULDNOTALLOCMEM, "Driver List create failed", __LINE__, __FILE__); 
  goto ReturnOut;
 }

 
 m_pDrvList->Initialize(funcResult, li_dmFilter);
 if(funcResult->GetFailed())
  goto ReturnOut;

 // Choose some defaults.
 m_pDrvList->SelectDefaultDriver(funcResult);
 if(funcResult->GetFailed())
  goto ReturnOut;

 m_pDrvList->SelectDefaultMode(funcResult);
 if(funcResult->GetFailed())
  goto ReturnOut;
 
 tempDrv = m_pDrvList->GetCurrentDriver(funcResult);
 if(funcResult->GetFailed())
  goto ReturnOut;

 tempMode = m_pDrvList->GetCurrentMode(funcResult);
 if(funcResult->GetFailed())
  goto ReturnOut;

 

 // Now ok to set the driver and mode.
 if(!jeEngine_SetDriverAndMode(worldManager->m_pEngine, worldManager->GetAppWnd(), tempDrv, tempMode)) 
 {
  funcResult->SetError("Set Driver/Mode failed", __LINE__, __FILE__);
  goto ReturnOut;
 }




  // Ok.
 ib_initialized = true;
 funcResult->SetOk();


ReturnOut:
 // All errors are init errors.
 if(funcResult->GetFailed())
  funcResult->SetInitError();
} 



