// Jet3d - JMiniApp
// Filename:render_manager_d.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/


/*****************************************************************************/
/*                             DEBUG VERSION                                 */
/*****************************************************************************/
 


#include "jmini_app.h"


/*****************************************************************************/
/*                      PROCESSING FUNCTIONS								 */
/*****************************************************************************/
















/******************************************************************************/
/*									INTERFACE FUNCTIONS		                  */
/******************************************************************************/






/*----------------------------------------------------------------------------
  Name:		GetWidthAndHeight(FuncResult *funcResult, long &al_width, long &al_height)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void
RenderManager::GetWidthAndHeight(FuncResult *funcResult, long &al_width, long &al_height)
{
 funcResult->SetUndef();

 if(!ib_initialized)
 {
  funcResult->SetError(FUNCR_OBJECTNOTINITIALIZED, __LINE__, __FILE__);
  goto ReturnOut;
 }




 al_width = SCREEN_HORZ_RES;
 al_height = SCREEN_VERT_RES;


 // Ok.
 funcResult->SetOk();

ReturnOut:
 return;
}


/*----------------------------------------------------------------------------
  Name:     DisplayMessage(char *ac_msg)
  Purpose:	Writes a user messages to the GDI screen DC.

  Notes:      

-----------------------------------------------------------------------------*/
void
RenderManager::DisplayMessage(char *ac_msg)
{
 COLORREF		oldColor;
 int			oldMode;
 //HGDIOBJ		oldObject;
 HPEN			oldPen;
 HBRUSH			oldBrush;
 int			x;
 int			y;
 SIZE			size;
 RECT			rect;
 int			nStrLen;
 HWND			hWnd;
 HDC			hdc;

 hWnd = worldManager->GetAppWnd();
 hdc = GetDC(hWnd);
  
 // Black background.
 oldPen   = (HPEN)SelectObject(hdc, GetStockObject (NULL_PEN));
 oldBrush = (HBRUSH)SelectObject(hdc, GetStockObject (BLACK_BRUSH));

 
 oldMode = SetBkMode(hdc, TRANSPARENT);
// oldObject = SelectObject(hdc, hLargeFont);
 oldColor = SetTextColor(hdc, RGB(255, 255, 0));
  
 // Clear the client area.
 GetClientRect(hWnd, &rect);
 Rectangle(hdc, rect.left, rect.top, rect.right + 1, rect.bottom + 1);

 // Draw the string centered in the client area.
 nStrLen = strlen(ac_msg);
 GetTextExtentPoint32(hdc, ac_msg, nStrLen, &size);
 x = (rect.right  - size.cx) / 2;
 y = (rect.bottom - size.cy) / 2;
 TextOut(hdc, x, y, ac_msg, nStrLen);

 // Clean up.
// SelectObject(hdc, oldObject);
 SetBkMode(hdc, oldMode);
 SetTextColor(hdc, oldColor);
 SelectObject (hdc, oldBrush);
 SelectObject (hdc, oldPen);
}

