// Jet3d - JMiniApp
// Filename:render_manager_r.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/


/*****************************************************************************/
/*                             RELEASE VERSION                               */
/*****************************************************************************/
 



#include "jmini_app.h"

/*****************************************************************************/
/*                      PROCESSING FUNCTIONS								 */
/*****************************************************************************/







/******************************************************************************/
/*									INTERFACE FUNCTIONS		                  */
/******************************************************************************/





/*----------------------------------------------------------------------------
  Name:		GetWidthAndHeight(FuncResult *funcResult, long &al_width, long &al_height)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void
RenderManager::GetWidthAndHeight(FuncResult *funcResult, long &al_width, long &al_height)
{
 jeDriver_Mode	*mode;
 
 // Init.
 funcResult->SetUndef();

 if(!ib_initialized)
 {
  funcResult->SetError(FUNCR_OBJECTNOTINITIALIZED, __LINE__, __FILE__);
  goto ReturnOut;
 }


 mode = m_pDrvList->GetCurrentMode(funcResult);
 if(funcResult->GetFailed())
  goto ReturnOut;

 jeDriver_ModeGetWidthHeight(mode, &al_width, &al_height);
 
 // Ok.
 funcResult->SetOk();

ReturnOut:
 return;
}



