// Jet3d - JMiniApp
// Filename:world_manager.h
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/



#ifndef __WORLD_MANAGER_H
#define __WORLD_MANAGER_H

class WorldManager 
{
 
 
 private:
  /*****************************************************************************/
  /*                             MEMBER DATA                                   */
  /*****************************************************************************/
  HWND					appHWnd;	// Handle of our one window.

  
  char					ic_appName[MAX_SMALL_STRING]; 
  char					ic_versionMsg[MAX_SMALL_STRING];
  bool					ib_initialized;
  float					if_lastTime;
  
  jeWorld				*m_pWorld;
  JLevel				*m_pLevel;
  

  bool					ib_showStats;
  int					ii_versionPosHeight;	
 
  
  /*****************************************************************************/
  /*                             PROCESSING FUNCTIONS                          */
  /*****************************************************************************/ 
  

  void			UpdateFrame(void);
  void			Release(void);


 public:
  /*****************************************************************************/
  /*									INTERFACE OBJECTS 	      			   */
  /*****************************************************************************/ 
  ErrorManager		*errorManager;
  RenderManager		*renderManager;
  CameraManager		*cameraManager;

  jeEngine			*m_pEngine;

 
  /*****************************************************************************/
  /*									INTERFACE FUNCTIONS		      		   */
  /*****************************************************************************/
  WorldManager(void);
  ~WorldManager(void);

 
    
  bool			GetInitialized(void)
  {
	return ib_initialized;
  }

  
 
  HWND			GetAppWnd(void) { return appHWnd; }

  void			InitializeWin(FuncResult *funcResult, HINSTANCE hInstance, int nCmdShow);
  void			InitializeWorld(FuncResult *funcResult);
 
  
 
  
  
  void			UpdateWorld(void);

  void 			QuitWithError(char *ac_errorTxt, bool ab_initError = false); 

 

  /*****************************************************************************/
  /*									   WRAPPERS		      				   */
  /*****************************************************************************/
  
  void			SetShowStats(void)
  {
   ib_showStats = !ib_showStats;
   

    if(m_pEngine)  
	 jeEngine_EnableFrameRateCounter(m_pEngine, ib_showStats);
   }




  // Camera Manager. 
  void			TurnLeft(bool ab_switch)
  {
   if(cameraManager)
    cameraManager->TurnLeft(ab_switch);
  }

  void			TurnRight(bool ab_switch)
  {
   if(cameraManager)
    cameraManager->TurnRight(ab_switch);
  }

  void			MoveForwards(bool ab_switch)
  {
   if(cameraManager)
    cameraManager->MoveForwards(ab_switch);
  }

  void			MoveBackwards(bool ab_switch)
  {
   if(cameraManager)
    cameraManager->MoveBackwards(ab_switch);
  }

#ifdef _DEBUG  
  void			DisplayMessage(char *ac_msg)
  {
   if(renderManager)
	renderManager->DisplayMessage(ac_msg);
  }
#endif

};



#endif
