// Jet3d - JMiniApp
// Filename:world_manager_d.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/


/*****************************************************************************/
/*                             DEBUG VERSION                                 */
/*****************************************************************************/
 


#include "jmini_app.h"








/*****************************************************************************/
/*                      PROCESSING FUNCTIONS								 */
/*****************************************************************************/




/******************************************************************************/
/*									INTERFACE FUNCTIONS		                  */
/******************************************************************************/

/*----------------------------------------------------------------------------
  Name:		InitializeWin(FuncResult *funcResult, HINSTANCE hInstance, int nCmdShow)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void 
WorldManager::InitializeWin(FuncResult *funcResult, HINSTANCE hInstance, int nCmdShow)
{
 HWND			hWnd;
 WNDCLASS		wndClass;
 RECT			rc1;
  
  // Init.
 funcResult->SetUndef();

 // Set 'this' applications name.
 strcpy(ic_appName, "Jet3D - JMiniApp (Debug Version)"); 

 // And version message.
 sprintf(ic_versionMsg,  "Jet3D JMiniApp - Version: %u.%u%u", NOVA_VERSION_MAJOR, NOVA_VERSION_MINOR1, NOVA_VERSION_MINOR2);


 // First register window class.
 wndClass.style			= 0;
 wndClass.lpfnWndProc  	= WindowProc; // Callback function.
 wndClass.cbClsExtra	= 0;
 wndClass.cbWndExtra	= 0;
 wndClass.hInstance		= hInstance;
 wndClass.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
 wndClass.hCursor		= LoadCursor(NULL, IDC_ARROW);
 wndClass.hbrBackground	= NULL;   
 wndClass.lpszMenuName	= NULL;
 wndClass.lpszClassName	= ic_appName; 

 
 
 if(RegisterClass(&wndClass) == 0) // Register class.
 {
  funcResult->SetError("World Manager initialization failed"); 
  goto ReturnOut;
 }


 
 // Set the desired size for the client area of the window.
 SetRect(&rc1, 0, 0, SCREEN_HORZ_RES, SCREEN_VERT_RES);

 // Adjust that to a size that includes the border, etc.
 AdjustWindowRectEx(&rc1,
	                WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX, // Extended window style.
				    false,	// Does the window have a menu?
                    WS_EX_CLIENTEDGE);	// Style of our main window.

  
 hWnd = CreateWindowEx(WS_EX_CLIENTEDGE,	// Extended window style.
					        ic_appName,				// The window class name.
 					        ic_appName,				// The window caption.
 					        WS_SYSMENU | WS_CAPTION | WS_MINIMIZEBOX, // Window style.
 					        CW_USEDEFAULT,		// Initial x pos.
 					        CW_USEDEFAULT,		// Initial y pos.
 					        rc1.right - rc1.left,	// Horz window size.
 					        rc1.bottom - rc1.top,	// Vert window size.
 					        NULL,					// Parent window handle.
 					        NULL,					// Menu handle.
 					        hInstance,			// Program instance handle.
 					        NULL);					// Creation params.


 // Check result of CreateWindow().
 if(hWnd == 0)
 {
  funcResult->SetError("World Manager initialization failed"); 
  goto ReturnOut;
 }
 
 
 ShowWindow(hWnd, nCmdShow);
 UpdateWindow(hWnd);
 
 
 // Record our window handle.
 appHWnd = hWnd;
 

 // Ok.
 funcResult->SetOk();
 

ReturnOut:
 return;
}







