// Jet3d - JMiniApp
// Filename:world_manager_r.cpp
/***************************************************************
Copyright (C) 2000 Novasoft Consulting

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Library General Public
License as published by the Free Software Foundation; either
version 2 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Library General Public License for more details.

You should have received a copy of the GNU Library General Public
License along with this library; if not, write to the Free
Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*****************************************************************/


/*****************************************************************************/
/*                             RELEASE VERSION                               */
/*****************************************************************************/
 



#include "jmini_app.h"








/*****************************************************************************/
/*                      PROCESSING FUNCTIONS								 */
/*****************************************************************************/




/******************************************************************************/
/*									INTERFACE FUNCTIONS		                  */
/******************************************************************************/

/*----------------------------------------------------------------------------
  Name:		InitializeWin(HINSTANCE hInstance, int nCmdShow)
  Purpose:
  Notes:      

  1.  
----------------------------------------------------------------------------*/
void
WorldManager::InitializeWin(FuncResult *funcResult, HINSTANCE hInstance, int nCmdShow)
{
 HWND			hWnd;
 WNDCLASS		wndClass;

 // Init.
 funcResult->SetUndef();
 

 // Set 'this' applications name.
 strcpy(ic_appName, "Jet3D - JMiniApp (Release Version)"); 

 // And version message.
 sprintf(ic_versionMsg,  "Jet3D JMiniApp - Version: %u.%u%u", NOVA_VERSION_MAJOR, NOVA_VERSION_MINOR1, NOVA_VERSION_MINOR2);



 // First register window class.
 wndClass.style			= 0;
 wndClass.lpfnWndProc  	= WindowProc; // Callback function.
 wndClass.cbClsExtra	= 0;
 wndClass.cbWndExtra	= 0;
 wndClass.hInstance		= hInstance;
 wndClass.hIcon			= LoadIcon(hInstance, MAKEINTRESOURCE(IDI_ICON1));
 wndClass.hCursor		= NULL;
 wndClass.hbrBackground	= NULL;   
 wndClass.lpszMenuName	= NULL;
 wndClass.lpszClassName	= ic_appName; 

 
 
 if(RegisterClass(&wndClass) == 0) // Register class.
 {
  funcResult->SetError("World Manager initialization failed", __LINE__, __FILE__); 
  goto ReturnOut;
 }


 
 // Now create the app's one window.
 hWnd = CreateWindowEx(WS_EX_TOPMOST, // Extended window style. 
	                   ic_appName,		  // The window class name.
 					   ic_appName,		  // The window caption.
 					   WS_POPUP,		  // Window style.
 					   0,				  // Initial x pos.
 					   0,				  // Initial y pos.
 					   GetSystemMetrics(SM_CXFULLSCREEN), // Horz window size.
 					   GetSystemMetrics(SM_CYFULLSCREEN), // Vert window size.
 					   NULL,          // Parent window handle.
 					   NULL,          // Menu handle.
 					   hInstance,	  // Program instance handle.
 					   NULL);         // Creation params.

 // Check result of CreateWindow().
 if(hWnd == 0)
 {
  funcResult->SetError("World Manager initialization failed", __LINE__, __FILE__); 
  goto ReturnOut;
 }
 
 
 ShowWindow(hWnd, nCmdShow);
 UpdateWindow(hWnd);
 
 
 // Record our window handle.
 appHWnd = hWnd;
 

 SetCursor(NULL);

 // Everything OK.
 funcResult->SetOk();


ReturnOut:
 // All errors are init errors.
 if(funcResult->GetFailed())
  funcResult->SetInitError();
 
 return;
}



