@echo off

del _buildok.txt

if "%1" == "" goto all
goto %1

:all

REM
REM  Huge monolithic build for all Jet3D components
REM

:engine
REM
REM  First we build the engine
REM
cd JetEngine
nmake -a -f Jet3D.mak CFG="Jet3D - Win32 Release"
if not exist releasedll\jet3D.dll goto fail
nmake -a -f Jet3D.mak CFG="Jet3D - Win32 Debug"
if not exist debugdll\jet3Dd.dll goto fail
cd ..
if "%1" != "" goto end

:editor
REM
REM  Now we get the SDK elements over to the editor
REM
cd Editor
md exe
call Update_Jet_Files.bat RELEASE
nmake -f jwe.mak CFG="jwe - Win32 Release"
if not exist exe\jedit.exe goto fail
cd ..
if "%1" != "" goto end

:objects
REM
REM  Now do all the editor objects
REM
cd Editor
md exe\objects
call Update_Jet_Files.bat DEBUG
cd objects

cd actorobj
nmake -a -f actorobj.mak CFG="ActorObj - Win32 Release"
if not exist ..\..\exe\objects\actorobj.dll goto fail
nmake -a -f actorobj.mak CFG="ActorObj - Win32 Debug"
if not exist ..\..\exe\objects\actorobj.ddl goto fail
cd ..

cd AmbObject
nmake -a -f AmbObject.mak CFG="AmbObject - Win32 Release"
if not exist ..\..\exe\objects\AmbObject.dll goto fail
nmake -a -f AmbObject.mak CFG="AmbObject - Win32 Debug"
if not exist ..\..\exe\objects\AmbObject.ddl goto fail
cd ..

cd BoxObject
nmake -a -f BoxObject.mak CFG="BoxObject - Win32 Release"
if not exist ..\..\exe\objects\BoxObject.dll goto fail
nmake -a -f BoxObject.mak CFG="BoxObject - Win32 Debug"
if not exist ..\..\exe\objects\BoxObject.ddl goto fail
cd ..

cd CamObject
nmake -a -f CamObject.mak CFG="CamObject - Win32 Release"
if not exist ..\..\exe\objects\CamObject.dll goto fail
nmake -a -f CamObject.mak CFG="CamObject - Win32 Debug"
if not exist ..\..\exe\objects\CamObject.ddl goto fail
cd ..

cd Corona
nmake -a -f Corona.mak CFG="Corona - Win32 Release"
if not exist ..\..\exe\objects\Corona.dll goto fail
nmake -a -f Corona.mak CFG="Corona - Win32 Debug"
if not exist ..\..\exe\objects\Corona.ddl goto fail
cd ..

cd DynamicLight
nmake -a -f DynamicLight.mak CFG="DynamicLight - Win32 Release"
if not exist ..\..\exe\objects\DynamicLight.dll goto fail
nmake -a -f DynamicLight.mak CFG="DynamicLight - Win32 Debug"
if not exist ..\..\exe\objects\DynamicLight.ddl goto fail
cd ..

cd ModelObject
nmake -a -f ModelObject.mak CFG="ModelObject - Win32 Release"
if not exist ..\..\exe\objects\ModelObject.dll goto fail
nmake -a -f ModelObject.mak CFG="ModelObject - Win32 Debug"
if not exist ..\..\exe\objects\ModelObject.ddl goto fail
cd ..

cd PathObject
nmake -a -f PathObject.mak CFG="PathObject - Win32 Release"
if not exist ..\..\exe\objects\PathObject.dll goto fail
nmake -a -f PathObject.mak CFG="PathObject - Win32 Debug"
if not exist ..\..\exe\objects\PathObject.ddl goto fail
cd ..

cd Portals
nmake -a -f Portals.mak CFG="Portals - Win32 Release"
if not exist ..\..\exe\objects\PortalObject.dll goto fail
nmake -a -f Portals.mak CFG="Portals - Win32 Debug"
if not exist ..\..\exe\objects\PortalObject.ddl goto fail
cd ..

cd Spout
nmake -a -f Spout.mak CFG="Spout - Win32 Release"
if not exist ..\..\exe\objects\Spout.dll goto fail
nmake -a -f Spout.mak CFG="Spout - Win32 Debug"
if not exist ..\..\exe\objects\Spout.ddl goto fail
cd ..

cd Terrain
nmake -a -f TerrainObj.mak CFG="terrainobj - Win32 Release"
if not exist ..\..\exe\objects\Terrain.dll goto fail
nmake -a -f TerrainObj.mak CFG="terrainobj - Win32 Debug"
if not exist ..\..\exe\objects\Terrain.ddl goto fail
cd ..

cd ..\..
if "%1" != "" goto end

:actortools
REM
REM  Now we build the actor tools.
REM
cd ActorTools

md release
md release\actbuild
md release\astudio
call Update_Jet_Files RELEASE

nmake -a -f ActBuild.mak CFG="ActBuild - Win32 Release"
if not exist release\actbuild\actbuild.exe goto fail

nmake -a -f AStudio.mak CFG="AStudio - Win32 Release"
if not exist release\astudio\astudio.exe goto fail

cd ..
if "%1" != "" goto end

:exporters
REM
REM  And finally the MAX exporter
REM
cd MaxExport
nmake -a -f jexp.mak CFG="jexp - Win32 NFO Release"
if not exist nforelease\nfoexp.dle goto fail

nmake -a -f jexp.mak CFG="jexp - Win32 KEY Release"
if not exist keyrelease\keyexp.dle goto fail

cd ..
if "%1" != "" goto end

echo Success > _buildok.txt

goto end

:fail
echo Build failed!

:end

