//*****************************************************************************
//FileName			: EntityObj.h *
//Author			: W. Scott Dillman
//Purpose			: Function definitions for Entity object
//Date Of Creation	: 3/3/2000
//Notes				: Most of this code is a patchwork of functions lifted
//					  from the other Jet3D objects... I only put my name 
//					  here as the one responsible for putting it together.
//					  The code assumes there is a bitmap in the main editor
//					  directory called 'start.bmp' much like the ambient object.
//Modification History:
//Date             Modifications
//*****************************************************************************

#include "Engine.h"
#include "Camera.h"
#include "jeFrustum.h"
#include "jeProperty.h"
#include "object.h"
#include "jeWorld.h"
#include "jeNameMgr.h"

//#define NEWSAVE_START 1
//#define NEWLOAD_START 1

#if !(NEWSAVE_START|NEWLOAD_START)
#include "jePtrMgr.h"
#endif

void Init_Class( HINSTANCE hInstance );
void Destroy_Class( void );
void * JETCC CreateInstance( void ); 
void  JETCC CreateRef(void * Instance);
jeBoolean JETCC Destroy(void **pInstance);
jeBoolean	JETCC Render(const void * Instance, const jeWorld * pWorld, const jeEngine *Engine, const jeCamera *Camera, const jeFrustum *CameraSpaceFrustum, jeObject_RenderFlags RenderFlags);
jeBoolean	JETCC AttachWorld( void * Instance, jeWorld * pWorld );
jeBoolean	JETCC DettachWorld( void * Instance, jeWorld * pWorld );
jeBoolean	JETCC AttachEngine ( void * Instance, jeEngine *Engine );
jeBoolean	JETCC DettachEngine( void * Instance, jeEngine *Engine );
jeBoolean	JETCC AttachSoundSystem( void * Instance, jeSound_System *SoundSystem );
jeBoolean	JETCC DettachSoundSystem( void * Instance, jeSound_System *SoundSystem );
jeBoolean	JETCC Collision(const jeObject *Object, const jeExtBox *Box, const jeVec3d *Front, const jeVec3d *Back, jeVec3d *Impact, jePlane *Plane);
jeBoolean JETCC SetMaterial(void * Instance,const jeBitmap *Bmp,const jeRGBA * Color);
jeBoolean JETCC GetMaterial(const void * Instance,jeBitmap **pBmp,jeRGBA * Color);
jeBoolean JETCC GetExtBox(const void * Instance,jeExtBox *BBox);

#if NEWLOAD_START
void *	JETCC CreateFromFile(jeVFile * File, jeNameMgr *NM);
#else
void *	JETCC CreateFromFile(jeVFile * File, jePtrMgr *PtrMgr);
#endif

#if NEWSAVE_START
jeBoolean	JETCC WriteToFile(const void * Instance,jeVFile * File, jeNameMgr *NM);
#else
jeBoolean	JETCC WriteToFile(const void * Instance,jeVFile * File, jePtrMgr *PtrMgr);
#endif

jeBoolean	JETCC GetPropertyList(void * Instance, jeProperty_List **List);
jeBoolean	JETCC SetProperty(void * Instance, int32 FieldID, PROPERTY_FIELD_TYPE DataType, jeProperty_Data * pData );
jeBoolean	JETCC SetXForm(void * Instance,const jeXForm3d *XF);
jeBoolean JETCC JETCC GetXForm(const void * Instance,jeXForm3d *XF);
int	JETCC GetXFormModFlags( const void * Instance );
jeBoolean JETCC GetChildren(const void * Instance,jeObject * Children,int MaxNumChildren);
jeBoolean JETCC AddChild(void * Instance,const jeObject * Child);
jeBoolean JETCC RemoveChild(void * Instance,const jeObject * Child);
jeBoolean JETCC EditDialog (void * Instance,HWND Parent);
jeBoolean JETCC MessageFunction (void *Instance,int32 Msg, void * Data);
jeBoolean	JETCC UpdateTimeDelta(void * Instance, float TimeDelta );
//Royce
void * JETCC DuplicateInstance(void * Instance);
//---
// Icestorm
jeBoolean	JETCC ChangeBoxCollision(const void *Instance,const jeVec3d *Pos, const jeExtBox *FrontBox, const jeExtBox *BackBox, jeExtBox *ImpactBox, jePlane *Plane);