/****************************************************************************************/
/*  COLORBTN.CPP                                                                        */
/*                                                                                      */
/*  Author:                                                                             */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
#include "stdafx.h"

#include "Colorbtn.h"

// CColorButton

CColorButton::CColorButton()
{
	mCurrentColor = RGB(255,255,255);
}

CColorButton::~CColorButton()
{
}


BEGIN_MESSAGE_MAP(CColorButton, CButton)
	//{{AFX_MSG_MAP(CColorButton)
	ON_CONTROL_REFLECT(BN_CLICKED, OnClicked)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CColorButton message handlers

void CColorButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	RECT ClientRect;

	// get a cdc
	CDC* pDC = CDC::FromHandle( lpDrawItemStruct->hDC );

	// now draw a solid rectangle
	pDC->FillSolidRect( &lpDrawItemStruct->rcItem, mCurrentColor);

	{
		// draw the button's text...
		CString Text;

		this->GetClientRect (&ClientRect);

		this->GetWindowText (Text);
		pDC->DrawText( Text, &ClientRect, DT_CENTER |DT_VCENTER|DT_SINGLELINE ) ;
	}
	// if we have the focus

	if( lpDrawItemStruct->itemState & ODS_FOCUS ) {
		// get a null brush
		CBrush *NullBrush = CBrush::FromHandle((HBRUSH)GetStockObject(NULL_BRUSH)), *OldBrush;

		// select the brush
		OldBrush = pDC->SelectObject( NullBrush );

		// draw a cute rectangle around it
		pDC->Rectangle(&lpDrawItemStruct->rcItem);

		// get old
		pDC->SelectObject( OldBrush );
	}
	pDC->DrawEdge( &ClientRect, EDGE_RAISED, BF_RECT ) ;
}// DrawItem

// this function returns our current Color
COLORREF CColorButton::GetColor()
{
	return mCurrentColor;
}// GetColor

void CColorButton::SetColor( COLORREF Color)
{
	mCurrentColor = Color;
	// update ourselves
	RedrawWindow();
}// SetColor

void CColorButton::OnClicked() 
{
	COLORREF Color ;
	CColorDialog dlg;

	// get a Color
	if (dlg.DoModal() == IDOK)
	{
		// assign what it was to the current Color
		Color = dlg.GetColor() ;
		if( mCurrentColor != Color )
		{
			CWnd * pParent ;

			mCurrentColor = Color ;

			pParent = GetParent( ) ;
			pParent->SendMessage( WM_UPDATECOLOR, 0, (DWORD)mCurrentColor );	// Tell them we changed
		
			// update ourselves
			RedrawWindow();
		}
	}
}// OnClicked
