/****************************************************************************************/
/*  JWE.H                                                                               */
/*                                                                                      */
/*  Author:                                                                             */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/

/* Open Source Revision -----------------------------------------------------------------
 By: Dennis Tierney (DJT) dtierney@oneoverz.com
 On: 12/27/99 9:01:22 PM
 Comments: Added mouse settings member.
----------------------------------------------------------------------------------------*/

#if !defined(AFX_GWE_H__37F4562E_C0E1_11D2_8B41_00104B70D76D__INCLUDED_)
#define AFX_GWE_H__37F4562E_C0E1_11D2_8B41_00104B70D76D__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#ifndef __AFXWIN_H__
	#error include 'stdafx.h' before including this file for PCH
#endif

#include "AppData.h"
#include "J3DApp.h"
#include "Settings.h"
#include "MaterialList.h"
#include "WndReg.h"
#include "MsgLog.h"

#include "resource.h"       // main symbols

/////////////////////////////////////////////////////////////////////////////
// CJweApp:
// See gwe.cpp for the implementation of this class
//

class CJweApp : public CJ3DApp
{
public:
	AppData * m_pAppData;
	Settings * m_pSettings;

//---------------------------------------------------
// Added DJT
//---------------------------------------------------
	MouseSettings *m_pMouseSettings;
//---------------------------------------------------
// End DJT
//---------------------------------------------------

	WindowRegister *m_WndReg;
	MsgLog *		m_pMsgLog;
	CJweApp();
	MaterialList_Struct *GetMaterialList();
	ShaderMaterialList_Struct *GetShaderList(); //cyrius
	void StartLogRecord();
	void EndLogRecord();
	void StartLogPlay();
	void EndLogPlay();
	jeBoolean GetAppPath( char * PathString, int BuffSize );
	BOOL InitObjects( char * DllPath);
private:
	MaterialList_Struct *MaterialList;
	ShaderMaterialList_Struct *ShaderList; //cyrius
	BOOL RegisterObject( HINSTANCE	DllHandle );

// Overrides
	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CJweApp)
	public:
	virtual BOOL InitInstance();
	virtual int ExitInstance();
	virtual BOOL PreTranslateMessage(MSG* pMsg);
	virtual BOOL OnIdle(LONG lCount);
	//}}AFX_VIRTUAL

// Implementation
	BOOL			GetDriverAndMode(jeEngine* pEngine, jeDriver **ppDriver, jeDriver_Mode **ppMode) ;
	const char*		GetDriverPath(void) ;



	COleTemplateServer m_server;
		// Server object for document creation
	//{{AFX_MSG(CJweApp)
	afx_msg void OnAppAbout();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};


/////////////////////////////////////////////////////////////////////////////

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_GWE_H__37F4562E_C0E1_11D2_8B41_00104B70D76D__INCLUDED_)
