/****************************************************************************************/
/*  BMP.C                                                                               */
/*                                                                                      */
/*  Author:                                                                             */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/

#include "ram.h"
#include "bmp.h"
// This will create a 24BIT bgr...
HBITMAP CreateHBitmapFromgeBitmap (jeBitmap *Bitmap, HDC hdc)
{
	jeBitmap * Lock;
	jePixelFormat Format;
	jeBitmap_Info info;
	HBITMAP hbm = NULL;

	// <> choose format to be 8,16,or 24, whichever is closest to Bitmap
	Format = JE_PIXELFORMAT_24BIT_BGR;

	if ( ! jeBitmap_LockForRead(Bitmap, &Lock, 0, 0, Format, JE_FALSE,0) )
	{
		return NULL;
	}

	jeBitmap_GetInfo(Lock,&info,NULL);

	if ( info.Format != Format )
		return NULL;
	{
		void * bits;
		BITMAPINFOHEADER bmih;
		int pelbytes;

		pelbytes = jePixelFormat_BytesPerPel(Format);
		bits = jeBitmap_GetBits(Lock);

		bmih.biSize = sizeof(bmih);
		bmih.biHeight = - info.Height;
		bmih.biPlanes = 1;
		bmih.biBitCount = 24;
		bmih.biCompression = BI_RGB;
		bmih.biSizeImage = 0;
		bmih.biXPelsPerMeter = bmih.biYPelsPerMeter = 10000;
		bmih.biClrUsed = bmih.biClrImportant = 0;

		if ( (info.Stride*pelbytes) == (((info.Stride*pelbytes)+3)&(~3)) )
		{
			bmih.biWidth = info.Stride;
			hbm = CreateDIBitmap( hdc, &bmih , CBM_INIT , bits, (BITMAPINFO *)&bmih , DIB_RGB_COLORS );
		}
		else
		{
			void * newbits;
			int Stride;

			bmih.biWidth = info.Width;
			Stride = (((info.Width*pelbytes)+3)&(~3));
			newbits = jeRam_Allocate(Stride * info.Height);
			if ( newbits )
			{
				char *newptr,*oldptr;
				int y;

				newptr = (char *)newbits;
				oldptr = (char *)bits;
				for(y=0; y<info.Height; y++)
				{
					memcpy(newptr,oldptr,(info.Width)*pelbytes);
					oldptr += info.Stride*pelbytes;
					newptr += Stride;
				}
				hbm = CreateDIBitmap( hdc, &bmih , CBM_INIT , newbits, (BITMAPINFO *)&bmih , DIB_RGB_COLORS );
				jeRam_Free(newbits);
			}
		}
	}

	jeBitmap_UnLock (Lock);

	return hbm;
}

HBITMAP Bmp_CreateEmpty24BitDIB( HDC hDC, int32 nWidth, int32 nHeight, void * pBits )
{
	BITMAPINFOHEADER bmih;

	bmih.biSize = sizeof( bmih ) ;
	bmih.biHeight = - nHeight ;
	bmih.biWidth = nWidth ;
	bmih.biPlanes = 1;
	bmih.biBitCount = 24;
	bmih.biCompression = BI_RGB;
	bmih.biSizeImage = 0;
	bmih.biXPelsPerMeter = bmih.biYPelsPerMeter = 10000;
	bmih.biClrUsed = bmih.biClrImportant = 0;

	return CreateDIBitmap( hDC, &bmih, CBM_INIT, pBits, (BITMAPINFO *)&bmih, DIB_RGB_COLORS ) ;
}// Bmp_CreateEmpty24BitDIB

/* EOF: Bmp.c */
