/****************************************************************************************/
/*  DRAWTOOL.C                                                                          */
/*                                                                                      */
/*  Author:                                                                             */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
#pragma warning(disable : 4201 4214 4115)
#include <Windows.h>
#include <Windowsx.h>
#pragma warning(default : 4201 4214 4115; disable : 4514)

#include "Ram.h"

#include	"DrawTool.h"
#include	"BmpPool.h"

static BmpPool *pBmpPool;

typedef struct jweBitmap
{
	HBITMAP			hOldBitmap;
	HDC				hMemDC;
	HBITMAP			hBitmap;
} jweBitmap;

typedef struct jwePen
{
	HPEN			hPen;
	HPEN			hOldPen;
} jwePen;

jeBoolean	InitDrawTools()
{
	pBmpPool = BmpPool_Create();
	if( pBmpPool == NULL )
		return( JE_FALSE );
	return( JE_TRUE );
}

void		FreeDrawTools()
{
	if(pBmpPool)
		BmpPool_Destroy(&pBmpPool);
}

jeBoolean	AddResBitmap( HINSTANCE hInstance, char * Name, jeBoolean hasInitialRef)
{
	jeBoolean result;

	if( pBmpPool == NULL )
		return( JE_FALSE );

	result = BmpPool_Add(pBmpPool, hInstance, Name);//return( BmpPool_Add( pBmpPool,  hInstace, Name ) );

	if(result && hasInitialRef) // If it has an initial ref, get an empty ref.
		BmpPool_Get(pBmpPool,Name);

	return result;
}

// Added by cjp (1/8/00) to allow bitmaps to have a name other than their filename.

jeBoolean	AddResBitmapWithName(HINSTANCE hInstance, char* fileName, char* bitmapName, jeBoolean hasInitialRef)
{

	jeBoolean result;

	if( pBmpPool == NULL)
		return (JE_FALSE);

	result = BmpPool_AddWithName(pBmpPool,hInstance, fileName,bitmapName);
	
	if(result && hasInitialRef) // If it has an initial ref, get an empty ref.
		BmpPool_Get(pBmpPool,bitmapName);

	return result;
}

// Cjp : Neccesary if you give the bitmap an initial ref count and don't clear the pool with FreeDrawTools
void		DeleteResBitmap(char* name)
{
	BmpPool_Release(pBmpPool,name);
}

jweBitmap * GetResBitmap( char * Name, int32 hDC )
{
	jweBitmap *pjweBitmap;

	if( pBmpPool == NULL )
		return( NULL );
	pjweBitmap = JE_RAM_ALLOCATE_STRUCT_CLEAR( jweBitmap );
	if( pjweBitmap == NULL )
		return( NULL );

	pjweBitmap->hBitmap = BmpPool_Get( pBmpPool, Name );
	if( pjweBitmap->hBitmap == NULL )
		goto GRB_ERR;
	pjweBitmap->hMemDC = CreateCompatibleDC( (HDC)hDC ) ;
	if( pjweBitmap->hMemDC == NULL )
		goto GRB_ERR;
	pjweBitmap->hOldBitmap = SelectObject( pjweBitmap->hMemDC, pjweBitmap->hBitmap );
	if( pjweBitmap->hOldBitmap == NULL )
		goto GRB_ERR;

	return( pjweBitmap  );

GRB_ERR:
	if( pjweBitmap->hOldBitmap != NULL )
		SelectBitmap( pjweBitmap->hMemDC, pjweBitmap->hOldBitmap ) ;
	if( pjweBitmap->hMemDC != NULL )
		DeleteDC( pjweBitmap->hMemDC ) ;
	if( pjweBitmap->hBitmap != NULL )
		BmpPool_Release( pBmpPool, Name );
	jeRam_Free( pjweBitmap );
	return( NULL );
}

	
void BlitJweBitmap( jweBitmap * pResBitmap, int32 hDC, int x, int y, int cx, int cy )
{
		BitBlt( (HDC)hDC, x, y, cx, cy, pResBitmap->hMemDC, 0, 0, SRCCOPY ) ;
}

void ReleaseJweBitmap( jweBitmap * pjweBitmap )
{
	if( pjweBitmap->hOldBitmap != NULL )
		SelectBitmap( pjweBitmap->hMemDC, pjweBitmap->hOldBitmap ) ;
	if( pjweBitmap->hMemDC != NULL )
		DeleteDC( pjweBitmap->hMemDC ) ;
	if( pjweBitmap->hBitmap != NULL )
		BmpPool_ReleasePtr( pBmpPool, pjweBitmap->hBitmap );
	jeRam_Free( pjweBitmap );
}

jwePen * Pen_SelectColor( int32 hDC, int32 R, int32 G, int32 B )
{
	jwePen *pjwePen;

	pjwePen = JE_RAM_ALLOCATE_STRUCT_CLEAR( jwePen );
	if( pjwePen == NULL )
		return( NULL );

	pjwePen->hPen = CreatePen( PS_SOLID, 1, RGB( R, G, B ) ) ;
	pjwePen->hOldPen = SelectPen( (HDC)hDC, pjwePen->hPen ) ;
	return( pjwePen );
}

jwePen	* Pen_SelectSelectedColor( int32 hDC ) 
{
	jwePen *pjwePen;

	pjwePen = JE_RAM_ALLOCATE_STRUCT_CLEAR( jwePen );
	if( pjwePen == NULL )
		return( NULL );

	pjwePen->hPen = CreatePen( PS_SOLID, 1, RGB( 255, 0, 0 ) ) ;
	pjwePen->hOldPen = SelectPen( (HDC)hDC, pjwePen->hPen ) ;
	return( pjwePen );
}

jwePen	*	Pen_SelectSelectedFaceColor( int32 hDC )
{
	jwePen *pjwePen;

	pjwePen = JE_RAM_ALLOCATE_STRUCT_CLEAR( jwePen );
	if( pjwePen == NULL )
		return( NULL );

	pjwePen->hPen = CreatePen( PS_SOLID, 1, RGB( 255, 0, 255 ) ) ;
	pjwePen->hOldPen = SelectPen( (HDC)hDC, pjwePen->hPen ) ;
	return( pjwePen );
}

jwePen	* Pen_SelectSubtractBrushColor( int32 hDC )
{
	jwePen *pjwePen;

	pjwePen = JE_RAM_ALLOCATE_STRUCT_CLEAR( jwePen );
	if( pjwePen == NULL )
		return( NULL );

	pjwePen->hPen = CreatePen( PS_SOLID, 1, RGB( 255, 255, 255 ) ) ;
	pjwePen->hOldPen = SelectPen( (HDC)hDC, pjwePen->hPen ) ;
	return( pjwePen );
}

jwePen	* Pen_SelectAddBrushColor( int32 hDC ) 
{
	jwePen *pjwePen;

	pjwePen = JE_RAM_ALLOCATE_STRUCT_CLEAR( jwePen );
	if( pjwePen == NULL )
		return( NULL );

	pjwePen->hPen = CreatePen( PS_SOLID, 1, RGB( 255, 128, 0 ) ) ;
	pjwePen->hOldPen = SelectPen( (HDC)hDC, pjwePen->hPen ) ;
	return( pjwePen );
}

void Pen_Release( jwePen * pPen, int32 hDC )
{
		SelectPen( (HDC)hDC, pPen->hOldPen ) ;
		DeletePen( pPen->hPen ) ;
		jeRam_Free( pPen );
}

jeBoolean	Pen_Polyline( int32 hDC, Point * pPoints, int32 nPoints )
{
	return Polyline( (HDC)hDC, (POINT*)pPoints, nPoints ) ;
}

