#include <Bitmap.h>
#include <View.h>

#include "G3DView.h"

G3DView::G3DView(BRect rect) : BView(rect,"G3DView 2.0", B_FOLLOW_ALL_SIDES,B_WILL_DRAW)
{
backBuffer = NULL;

// we dont want the app server erasing our window now do we ?
//SetViewColor(B_TRANSPARENT_COLOR);

}

G3DView::~G3DView()
{
	DestroyBitmap();
}

// The display driver is responsible for slamming the data in the window..
/*
void G3DView::Draw(BRect updateRect)
{


}
*/

void G3DView::Draw(BRect updateRect)
{

//if(backBuffer)
//{
//	DrawBitmap(backBuffer,BPoint(0,0));
//	Sync();
//}

	BView::Draw(updateRect);
}

// Warning, you must create you BApp before this is called.... crashes will occur...

bool G3DView::CreateBitmap(float width, float height, color_space colorspace)
{
	BRect boundsRect;
	boundsRect.right = width -1.0f;
	boundsRect.bottom = height - 1.0f;
	boundsRect.top = boundsRect.left = 0.0f;
	//(0.0,0.0,width - 1.0f,height - 1.0f};
	
	// we need our backbuffer to be continguous because we may directly manipulate the bits.
	backBuffer = new BBitmap(boundsRect,colorspace,false,true);
	
	return (backBuffer != NULL);
	
}

void G3DView::DestroyBitmap()
{
	if(backBuffer)
	{
		delete backBuffer;
		backBuffer = NULL;
	}
}