/****************************************************************************************/
/*  INTMATH.C                                                                           */
/*                                                                                      */
/*  Author:                                                                             */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
#include "IntMath.h"
#include "Cpu.h"

#pragma warning(disable : 4244 4018)

uint32 square(uint32 val)
{
return ( val >= 0xFFFF ) ? (~(uint32)0) : val*val;
}

int intlog2(uint32 x) // !!! // <> do this in assembly for awesome speed
{
float xf;
	jeCPU_PauseMMX();
	xf = x;
	jeCPU_ResumeMMX();
return ((*(int*)&xf) >> 23) - 127;
}

	static int bits[256] = {
      0,0,1,1,2,2,2,2,3,3,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,
      5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
      6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
      6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
      7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7
	};

int intlog2_noif(register uint16 N) /** truncated **/
{
	static int throw_small[64] = {
	 0, 1, 2, 3, 4, 5, 6, 7, 9, 9, 9, 9, 9, 9, 9, 9,
	10,10,10,10,10,10,10,10,11,11,11,11,11,11,11,11,
	12,12,12,12,12,12,12,12,13,13,13,13,13,13,13,13,
	14,14,14,14,14,14,14,14,15,15,15,15,15,15,15,15
	};

	return throw_small[ (bits[ N>>8 ]<<3) + bits[ N & 0xFF ] ];
}

int intlog2_uw(register uint16 N) /** truncated **/
{
	if ( N >> 8 ) {
		return (8 + bits[N >> 8]);
	} else {
		return bits[N];
	}
}

#if 0
int intlog2(uint32 N) /** truncated **/
{
	if ( N >> 16 ) {
		if ( N >> 24 ) {
			return (24 + bits[N >> 24]);
		} else {
			return (16 + bits[N >> 16]);
		}
	} else {
		if ( N >> 8 ) {
			return (8 + bits[N >> 8]);
		} else {
			return bits[N];
		}
	}
}
#endif

int intlog2x10(uint32 N) /** rounded **/
{
	static unsigned char log2x10_table[256] = {    0, 0,
		   10,16,20,23,26,28,30,32,33,35,36,37,38,39,40,
		41,42,42,43,44,45,45,46,46,47,48,48,49,49,50,50,
		50,51,51,52,52,52,53,53,54,54,54,55,55,55,56,56,
		56,56,57,57,57,58,58,58,58,59,59,59,59,60,60,60,
		60,60,61,61,61,61,61,62,62,62,62,62,63,63,63,63,
		63,64,64,64,64,64,64,65,65,65,65,65,65,66,66,66,
		66,66,66,66,67,67,67,67,67,67,67,68,68,68,68,68,
		68,68,68,69,69,69,69,69,69,69,69,70,70,70,70,70,
		70,70,70,70,71,71,71,71,71,71,71,71,71,71,72,72,
		72,72,72,72,72,72,72,72,73,73,73,73,73,73,73,73,
		73,73,73,74,74,74,74,74,74,74,74,74,74,74,75,75,
		75,75,75,75,75,75,75,75,75,75,75,76,76,76,76,76,
		76,76,76,76,76,76,76,76,77,77,77,77,77,77,77,77,
		77,77,77,77,77,77,77,78,78,78,78,78,78,78,78,78,
		78,78,78,78,78,78,79,79,79,79,79,79,79,79,79,79,
		79,79,79,79,79,79,79,80,80,80,80,80,80,80,80	};

	if ( N < 256 ) {
		return log2x10_table[N];
	} else {
		int b;
		b = 9;
		while( N > ((uint32)1<<b) ) b++;
		return b*10 - 80 + log2x10_table[ N>>(b-8) ];
	}
}

int intlog2x16(uint32 N) /** rounded **/
{
	static unsigned char log2x16_table[256] = {	0,
	 0,16,25,32,37,41,45,48,51,53,55,57,59,61,63,64,
	65,67,68,69,70,71,72,73,74,75,76,77,78,79,79,80,
	81,81,82,83,83,84,85,85,86,86,87,87,88,88,89,89,
	90,90,91,91,92,92,93,93,93,94,94,95,95,95,96,96,
	96,97,97,97,98,98,98,99,99,99,100,100,100,101,101,101,
	101,102,102,102,103,103,103,103,104,104,104,104,105,105,105,105,
	106,106,106,106,107,107,107,107,107,108,108,108,108,109,109,109,
	109,109,110,110,110,110,110,111,111,111,111,111,111,112,112,112,
	112,112,113,113,113,113,113,113,114,114,114,114,114,114,115,115,
	115,115,115,115,116,116,116,116,116,116,116,117,117,117,117,117,
	117,117,118,118,118,118,118,118,118,119,119,119,119,119,119,119,
	119,120,120,120,120,120,120,120,121,121,121,121,121,121,121,121,
	121,122,122,122,122,122,122,122,122,123,123,123,123,123,123,123,
	123,123,124,124,124,124,124,124,124,124,124,125,125,125,125,125,
	125,125,125,125,125,126,126,126,126,126,126,126,126,126,126,127,
	127,127,127,127,127,127,127,127,127,127,128,128,128,128,128	};

	if ( N < 256 ) {
		return log2x16_table[N];
	} else {
		int b;
		b = 9;
		while( N > ((uint32)1<<b) ) b++;
		return ((b - 8)<<4) + log2x16_table[ N>>(b-8) ];
	}
}

int intlog2r(uint32 N) /** rounded **/
{
 static unsigned char rbits[256] = {
	0,0,1,2,2,2,3,3,3,3,3,3,4,4,4,4,4,4,4,4,4,4,4,
	5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,5,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,6,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,7,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
	8,8,8,8,8
  };

	if ( N >> 16 ) {
		if ( N >> 24 ) {
			return (24 + rbits[N >> 24]);
		} else {
			return (16 + rbits[N >> 16]);
		}
	} else {
		if ( N >> 8 ) {
			return (8 + rbits[N >> 8]);
		} else {
			return rbits[N];
		}
	}
}

uint32 isqrt(uint32 N)
{
static const uint8 sqrtable[] = {
0, 1,1, 2,2,2,2, 3,3,3,3,3,3, 4,4,4,4,4,4,4,4,4,
5,5,5,5,5,5,5,5,5,5, 6,6,6,6,6,6,6,6,6,6,6,6,
7,7,7,7,7,7,7,7,7,7,7,7,7,7, 8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,8,
9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,9,
10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,12,
13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,13,
14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,14,
15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,15,
16,16,16,16,16,16,16,16,16,16,16,16 };

	/** get a quick estimate **/

if ( N >= 256 ) {
	long diff;
	uint32 step,s;

	if ( N >> 16 ) {
		if ( N >> 24 )	s = sqrtable[N >>24]<<12;
		else 			s = sqrtable[N >>16]<<8;
	} else {
		s = sqrtable[N >> 8]<<4;
	}

diff = N - s*s;

if ( mabs(diff) < 2*s ) return s;

step = isqrt(mabs(diff));

	for(;;) {
		step >>= 1; if ( step == 0 ) break;

		if ( diff > 0 ) s += step;
		else if ( diff < 0 ) s -= step;
		else break;

		diff = N - (s*s);
		if ( mabs(diff) < 2*s ) return s;
	}

	if ( (N - (s-1)*(s-1)) < mabs(diff) ) s--;
	else if ( (N - (s+1)*(s+1)) < mabs(diff) ) s++;

	return s;
  }

return sqrtable[N];
}


int GaussianRand(int val,int step)
{
int r;

	r = 0;

restart:

	r >>= 1;	if ( ! r ) r = rand() >> 1;
	if ( r&1 ) step = - step;

	step /= 2;
	if ( step == 0 ) return val;

	for(;;)
	{
		r >>= 1;	if ( ! r ) r = rand() >> 1;
		if ( r & 1 )
			val += step;
		else
		{
			//	return val + (rand()*step)/RAND_MAX;
			// step /= 2;
			val += (rand()*step)/RAND_MAX;
			goto restart;
		}
	}
}
