#include <DirectGLWindow.h>
#include <stdio.h>

#include <GL/gl.h>
#include "G3DView.h"
#include "Dcommon.h"
#include "BeSpec.h"
#include "JetDirect.h"

extern JetDirectWindow* pDirectGLWindow;

static bool vsyncEnabled = JE_FALSE;

void WindowSetup(DRV_DriverHook *Hook)
{
	//Driver
	//Mode
	uint32 deviceID = (pDirectGLWindow->GetGfxDevice(Hook->Driver))->deviceID;
	printf("Chose device %s\n",(pDirectGLWindow->GetGfxDevice(Hook->Driver))->name);
	
	if( pDirectGLWindow->InitializeGL( deviceID, BGL_FASTEST | BGL_DOUBLE, 16, BGL_NONE, BGL_NONE ) < B_OK )
		if( pDirectGLWindow->InitializeGL( deviceID, BGL_FASTEST | BGL_DOUBLE, BGL_ANY, BGL_NONE, BGL_NONE ) < B_OK )
		{
			printf( "Error from InitializeGL \n" );
			return;
		}
	
if(Hook->Width != -1 || Hook->Height != -1)
	pDirectGLWindow->FullscreenEnable( Hook->Width,  Hook->Height );
else
	pDirectGLWindow->FullscreenDisable();
	
// Update the size of our window based on the size of theirs..

	BWindow* pWindow = Hook->hWnd->Window();
	BRect windowSize = pWindow->Bounds();
	
	pDirectGLWindow->ResizeTo(windowSize.right - windowSize.left , windowSize.bottom - windowSize.top);
	pDirectGLWindow->UpdateGLRect(windowSize);
	
	// Now steal their G3DView* and embed it in our DirectGLWindow
	G3DView* pView = Hook->hWnd;

	pWindow->Lock();
	pWindow->RemoveChild(pView);
	pWindow->Unlock();

	pDirectGLWindow->Lock(); // Neccesary?
	pDirectGLWindow->AddChild(pView);
	pDirectGLWindow->Unlock();
	
	pDirectGLWindow->Show();
	
	printf("WindowSetup success\n");
}

void SetGLPixelFormat(DRV_DriverHook *Hook)
{
	

}

void FlipGLBuffers()
{
	pDirectGLWindow->SwapBuffers( vsyncEnabled );
}

bool SetFullscreen(DRV_DriverHook *Hook)
{
	pDirectGLWindow->MakeCurrent();	
	pDirectGLWindow->FullscreenEnable( Hook->Width, Hook->Height );
	glViewport( 0, 0, Hook->Width, Hook->Height );
	pDirectGLWindow->ReleaseCurrent();
	
	return true;
}