#include <Application.h>
#include <stdio.h>

#include "JetDirect.h"

JetDirectWindow::JetDirectWindow(const char* title , BRect* displayRect) :  BDirectGLWindow( *displayRect , title, B_TITLED_WINDOW_LOOK, B_NORMAL_WINDOW_FEEL, B_ASYNCHRONOUS_CONTROLS | B_NOT_ZOOMABLE )
{
	currentDevice = -1;
	EnumerateDevices( BGL_MONITOR_ANY, BGL_ANY | BGL_DOUBLE, BGL_ANY, BGL_NONE, BGL_NONE );
}

JetDirectWindow::~JetDirectWindow()
{

}


void JetDirectWindow::FrameResized( float width, float height )
{
//printf( "frameResized  %f, %f \n", width, height );
	MakeCurrent();
	if( fullscreenEnabled )
	{
		glViewport( 0, 0, fullscreenWidth, fullscreenHeight );
	}
	else
	{
		glViewport( 0, 0, int(width-1), int(height-1) );
	}
	ReleaseCurrent();
}

#if 0
BRect JetDirectWindow::UpdateGLRect( BRect window_rect )
{
	BRect r;
//printf( "UpdateGLRect in %f, %f \n", window_rect.right, window_rect.bottom );
#if 0
	if( fullscreenEnabled )
	{
		r = BRect( 0, 0, fullscreenWidth-1, fullscreenHeight-1 );
	}
	else
	{
		r = window_rect;
		if( r.bottom > MENU_HEIGHT )
			r.top += MENU_HEIGHT;
		else
			r.bottom = 0;
	}
#endif
//printf( "UpdateGLRect %f, %f \n", r.right, r.bottom );
	return r;
}
#endif

void JetDirectWindow::DeviceInfo( uint32 device_id, uint32 monitor, const char *name, bool depth, bool stencil, bool accum )
{
	char buf[256];
	
	currentDevice++;
	devices[currentDevice].deviceID = device_id;
	devices[currentDevice].first = 0;

	strcpy((char *)&devices[currentDevice].name , name);
}

void JetDirectWindow::VideoModeInfo( uint32 width, uint32 height, uint32 color, uint32 depth, uint32 stencil, uint32 accum )
{

// Check if we already have a windowed mode.. if we do don't add it again..
if(width == BGL_WINDOWED)
{
	if( devices[currentDevice].first )
	{
		ModeInfo *last = devices[currentDevice].first;
		while(last)
		{
			if(last->xres == BGL_WINDOWED)
				return;
			last = last->next;
		}
	}
}

	ModeInfo *m = new ModeInfo;
	
	m->next = 0;
	m->xres = width;
	m->yres = height;

	color &= ~BGL_DOUBLE;

if(color == BGL_8_BIT)
	m->color = 8;
else if( color == BGL_15_BIT)
	m->color = 15;
else if(color == BGL_16_BIT)
	m->color = 16;
else if(color == BGL_24_BIT)
	m->color = 24;
else if(color == BGL_32_BIT)
	m->color = 32;
	
	if( devices[currentDevice].first )
	{
		ModeInfo *last = devices[currentDevice].first;
		while( last->next )
			last = last->next;
		last->next = m;
	}
	else
	{
		devices[currentDevice].first = m;
	}

//	printf( "VideoModeInfo   width=%i     height=%i \n", width, height );
//	printf( "                color=%i     depth=%i    stencil=%i   accum=%i \n", color, depth, stencil, accum );
//	printf( "VideoModeInfo   width=%i     height=%i \n", width, height );
//	printf( "                color=0x%x  depth=0x%x    stencil=0x%x   accum=0x%x \n", color, depth, stencil, accum );

}


bool JetDirectWindow::QuitRequested( void )
{
	be_app->PostMessage( B_QUIT_REQUESTED );
	return false;
}

void JetDirectWindow::MessageReceived( BMessage *msg )
{
		BDirectWindow::MessageReceived( msg );
}

#include <assert.h>

GfxDevice* JetDirectWindow::GetGfxDevice(int deviceNum)
{
	assert(deviceNum >= 0);
	assert(deviceNum <= MAX_DEVICES);
	
//	printf("DeviceNum %i , currentdevice %i \n" , deviceNum , currentDevice);
	
	if(deviceNum > currentDevice)
		return NULL;
	
	return &devices[deviceNum];
}

ModeInfo* JetDirectWindow::GetModeInfo(GfxDeviceRec* pDevice, ModeInfo* pPrevious)
{
	assert(pDevice);
	
	if(pPrevious)
		return pPrevious->next;
	else
		return pDevice->first;
}

void  JetDirectWindow::ErrorCallback(GLenum errorCode)
{
	// Print message..
}
	


