#ifndef CJP_NEWOGLDRIVER_GLDIRECT_H__
#define CJP_NEWOGLDRIVER_GLDIRECT_H__

#include <DirectGLWindow.h>
#include <support/Locker.h>
#include <kernel/OS.h>

#define MAX_DEVICES 16
typedef struct ModeInfoRec ModeInfo;
struct ModeInfoRec
{
	ModeInfo *next;
	uint32 xres;
	uint32 yres;
	uint32 color;
};

typedef struct GfxDeviceRec
{
	uint32 deviceID;
	const char name[256];
	ModeInfo *first;
} GfxDevice;

class JetDirectWindow : public 	BDirectGLWindow
{
public:
	JetDirectWindow( const char *title , BRect* displayRect);
	virtual ~JetDirectWindow( void );

	virtual bool QuitRequested( void );
	virtual void MessageReceived( BMessage *msg );
	virtual void FrameResized( float width, float height );
//	virtual BRect UpdateGLRect( BRect window_rect );
	
	virtual void DeviceInfo( uint32 device_id, uint32 monitor, const char *name, bool depth, bool stencil, bool accum );
	virtual void VideoModeInfo( uint32 width, uint32 height, uint32 color, uint32 depth, uint32 stencil, uint32 accum );
	
	GfxDevice* GetGfxDevice(int deviceNum);
	ModeInfo* GetModeInfo(GfxDeviceRec* pDevice, ModeInfo* pPrevious);
	
	virtual	void ErrorCallback (GLenum errorCode);
private:

	bool fullscreenEnabled;
	int32 fullscreenWidth;
	int32 fullscreenHeight;
	
	int32 currentDevice;
	GfxDevice devices[MAX_DEVICES];
};

#endif

