/****************************************************************************************/

/*  OglDrv.h                                                                            */

/*                                                                                      */

/*  Author: George McBay (gfm@my-deja.com)                                              */

/*	Jet3D Modifications: Christopher Plymire (chrisjp@eudoramail.com)					*/

/*																						*/

/*  Description: Exposed interface for OpenGL version of Genesis Driver                 */

/*                                                                                      */

/*  The contents of this file are subject to the Genesis3D Public License               */

/*  Version 1.01 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.genesis3d.com                                                            */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*                                                                                      */

/****************************************************************************************/



#ifndef OGLDRV_H

#define OGLDRV_H



#include "Dcommon.h"



#ifdef WIN32

#include "glext.h"

#endif



// Here are some useful values you can change to meet your needs.

// These should, in the future, really be handled at run-time as opposed to compile-time.

// The defaults work well with TNT2 based cards.

#define COLOR_DEPTH			16		// Bits per pixel to use for OpenGL Window/Context

#define ZBUFFER_DEPTH		16		// Depth of the ZBuffer to use in OpenGL.   



// Will have to reenable this=)

#define USE_LIGHTMAPS					// Render lightmaps



#define USE_LINEAR_INTERPOLATION		// Comment out to use nearest neighbor interpolation

//#define TRILINEAR_INTERPOLATION		// Comment out to use bilinear interpolation





extern		DRV_Driver	OGLDRV;

extern		DRV_Window	ClientWindow;



#ifdef WIN32

extern		PFNGLACTIVETEXTUREARBPROC glActiveTextureARB;

extern      PFNGLMULTITEXCOORD4FARBPROC glMultiTexCoord4fARB;

#endif

extern		GLboolean multitexture;



extern		GLint maxTextureSize;



jeBoolean DRIVERCC SetFogEnable(jeBoolean Enable, float r, float g, float b, float Start, float End);

jeBoolean DRIVERCC DrvInit(DRV_DriverHook *Hook);

jeBoolean DRIVERCC DrvShutdown(void);

jeBoolean DRIVERCC DrvUpdateWindow(void);

jeBoolean DRIVERCC DrvSetActive(jeBoolean Active);

jeBoolean DRIVERCC SetGamma(float Gamma);

jeBoolean DRIVERCC GetGamma(float *Gamma);

jeBoolean DRIVERCC ScreenShot(const char *Name);

jeBoolean DRIVERCC EnumSubDrivers(DRV_ENUM_DRV_CB *Cb, void *Context);

jeBoolean DRIVERCC EnumModes(int32 Driver, char *DriverName, DRV_ENUM_MODES_CB *Cb, void *Context);

jeBoolean DRIVERCC EnumPixelFormats(DRV_ENUM_PFORMAT_CB *Cb, void *Context);

void SetLastDrvError(int32 Error, char *ErrorStr);



#endif