/****************************************************************************************/

/*  Render.h                                                                            */

/*                                                                                      */

/*  Author: George McBay (gfm@my-deja.com)                                              */

/*	Jet3D Modifications: Christopher Plymire (chrisjp@eudoramail.com)					*/

/*																						*/

/*  Description: Polygon rasterization functions for OpenGL driver                      */

/*                                                                                      */

/*  The contents of this file are subject to the Genesis3D Public License               */

/*  Version 1.01 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.genesis3d.com                                                            */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*                                                                                      */

/****************************************************************************************/



#ifndef RENDER_H

#define RENDER_H



#include "Dcommon.h"



#ifdef __cplusplus

extern "C" {

#endif



enum 

{  

	RENDER_UNKNOWN_MODE,

	RENDER_MISC_TEX_POLY_MODE, 

	RENDER_MISC_GOURAD_POLY_MODE, 

	RENDER_LINES_POLY_MODE, 

	RENDER_WORLD_TRANSPARENT_POLY_MODE,

	RENDER_WORLD_POLY_MODE,

	RENDER_LIGHTMAP_POLY_MODE,

	RENDER_LIGHTMAP_FOG_POLY_MODE,

	RENDER_DECAL_MODE,

};



extern uint32				PolyMode;

extern DRV_CacheInfo		CacheInfo;

extern GLuint decalTexObj;



void Render_SetHardwareMode(int32 NewMode, uint32 NewFlags);



jeBoolean DRIVERCC Render_GouraudPoly(jeTLVertex *Pnts, int32 NumPoints, uint32 Flags);

jeBoolean DRIVERCC Render_WorldPoly(jeTLVertex *Pnts, int32 NumPoints, jeRDriver_Layer *Layers, int32 NumLayers, void *LMapCBContext, uint32 Flags);

jeBoolean DRIVERCC Render_MiscTexturePoly(jeTLVertex *Pnts, int32 NumPoints, jeRDriver_Layer *Layers, int32 NumLayers, uint32 Flags);



jeBoolean DRIVERCC DrawDecal(jeRDriver_THandle *THandle, RECT *SRect, int32 x, int32 y);



jeBoolean DRIVERCC BeginScene(jeBoolean Clear, jeBoolean ClearZ, RECT *WorldRect);

jeBoolean DRIVERCC EndScene(void);





#ifdef __cplusplus

}

#endif



#endif