/****************************************************************************************/

/*  THandle.h                                                                           */

/*                                                                                      */

/*  Author: George McBay (gfm@my-deja.com)                                              */

/*	Jet3D Modifications: Christopher Plymire (chrisjp@eudoramail.com)					*/

/*																						*/

/*  Description: Texture handle manager for OpenGL driver                               */

/*                                                                                      */

/*  The contents of this file are subject to the Genesis3D Public License               */

/*  Version 1.01 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.genesis3d.com                                                            */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*                                                                                      */

/****************************************************************************************/



#ifndef THANDLE_H

#define THANDLE_H



#include <GL/gl.h>

#include <GL/glu.h>



#include "Dcommon.h"

#include "OglMisc.h"



#define	MAX_TEXTURE_HANDLES			20000

#define THANDLE_MAX_MIP_LEVELS		16



// THandle flags

#define THANDLE_UPDATE		(1<<0)		// Force a thandle to be uploaded to the card

#define	THANDLE_TRANS		(1<<2)		// Texture has transparency

#define THANDLE_LOCKED		(1<<3)		// THandle is currently locked (invalid for rendering etc)

#define THANDLE_UPDATE_LM	(1<<4)		// THandle is a lightmap that needs updating



typedef struct jeRDriver_THandle

{

	GLboolean				Active;

	GLint					Width, Height, MipLevels;

	GLint					PaddedWidth, PaddedHeight;

	jeRDriver_PixelFormat	PixelFormat;

	GLuint					Flags;

	GLuint					TextureID;

	GLubyte					*Data[THANDLE_MAX_MIP_LEVELS];

	GLfloat					InvScale;



	jeRDriver_THandle*		PalHandle;

}jeRDriver_THandle;



extern	jeRDriver_THandle	TextureHandles[MAX_TEXTURE_HANDLES];



jeBoolean						FreeAllTextureHandles(void);

jeBoolean			DRIVERCC	DrvResetAll(void);

jeRDriver_THandle	*DRIVERCC	THandle_Create(int32 Width, int32 Height, int32 NumMipLevels, const jeRDriver_PixelFormat *PixelFormat);

jeBoolean			DRIVERCC	THandle_Destroy(jeRDriver_THandle *THandle);

jeBoolean			DRIVERCC	THandle_Lock(jeRDriver_THandle *THandle, int32 MipLevel, void **Data);

jeBoolean			DRIVERCC	THandle_UnLock(jeRDriver_THandle *THandle, int32 MipLevel);

jeBoolean			DRIVERCC	THandle_GetInfo(jeRDriver_THandle *THandle, int32 MipLevel, jeRDriver_THandleInfo *Info);

void							THandle_Update(jeRDriver_THandle *THandle);



void THandle_DownloadLightmap(jeRDriver_THandle *THandle, 	jeRDriver_LMapCBInfo *LInfo);

//void							THandle_DownloadLightmap(jeRDriver_LMapCBInfo *LInfo);



// Palette texture support

jeBoolean DRIVERCC THandle_SetPalette(jeRDriver_THandle *THandle, jeRDriver_THandle *PalHandle);

jeRDriver_THandle *DRIVERCC THandle_GetPalette(jeRDriver_THandle *THandle);



int32 GetLog(int32 Width, int32 Height);

uint32 Log2(uint32 P2);

S32 SnapToPower2(S32 Width);



jeBoolean THandle_Startup(void);



#endif

