/****************************************************************************************/

/*  DisplayModeInfo.C                                                                   */

/*                                                                                      */

/*  Author:  Mike Sandige                                                               */

/*  Description:  This is a simple container to hold information about available display*/

/*                modes for the software driver.                                        */

/*                                                                                      */

/*  The contents of this file are subject to the Jet3D Public License                   */

/*  Version 1.02 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.jet3d.com                                                                */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*  The Original Code is Jet3D, released December 12, 1999.                             */

/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */

/*                                                                                      */

/****************************************************************************************/

#include <stdlib.h>

#include <assert.h>

#include "DisplayModeInfo.h"

#include "Errorlog.h"





#define DISPLAYMODES_MAX 16



typedef struct DisplayModeInfo_Data

{

	int		Width;

	int		Height;

	int		BitsPerPixel;

	uint32	Flags;

}	DisplayModeInfo_Data;





typedef struct DisplayModeInfo

{

	DisplayModeInfo_Data	 Mode[DISPLAYMODES_MAX];

	int						 ModeCount;

}	DisplayModeInfo;





DisplayModeInfo *DisplayModeInfo_Create(void)

{

	DisplayModeInfo *Info;



	Info = (DisplayModeInfo *)malloc(sizeof(*Info));

	if (Info == NULL)

		{

			jeErrorLog_AddString(JE_ERR_MEMORY_RESOURCE,"DisplayModeInfo:  unable to get memory for object",NULL);

			return NULL;

		}

	Info-> ModeCount = 0;

	return Info;

}



void DisplayModeInfo_Destroy(DisplayModeInfo **Info)

{

	assert ( Info != NULL );

	assert (*Info != NULL );

	free ( *Info );

	*Info = NULL;

}



int DisplayModeInfo_GetModeCount(DisplayModeInfo *Info)

{

	assert( Info != NULL );



	return Info->ModeCount;

}



jeBoolean DisplayModeInfo_AddEntry(DisplayModeInfo *Info, 

				int Width,

				int Height,

				int BitsPerPixel,

				uint32 Flags)

{

	assert( Info != NULL );



	if (Info->ModeCount<DISPLAYMODES_MAX)

		{

			Info->Mode[Info->ModeCount].Width        = Width;

			Info->Mode[Info->ModeCount].Height       = Height;

			Info->Mode[Info->ModeCount].BitsPerPixel = BitsPerPixel;

			Info->Mode[Info->ModeCount].Flags        = Flags;

			Info->ModeCount++;

			return JE_TRUE;

		}

	else

		{

			jeErrorLog_AddString(JE_ERR_INTERNAL_RESOURCE,"JE_DisplayModeInfo_AddEntry:Too many modes",NULL);

			return JE_FALSE;

		}

}



jeBoolean DisplayModeInfo_GetNth(DisplayModeInfo *Info, int Nth,

				int *Width, 

				int *Height,

				int *BitsPerPixel,

				uint32 *Flags)

{

	assert( Info != NULL );

	assert( Width        != NULL );

	assert( Height       != NULL );

	assert( BitsPerPixel != NULL );

	assert( Flags        != NULL );

	if ((Nth < 0) || (Nth > Info->ModeCount))

		{

			jeErrorLog_AddString(JE_ERR_BAD_PARAMETER,"DisplayModeInfo_GetNth:  bad mode index",jeErrorLog_IntToString(Nth));

			return JE_FALSE;

		}



	*Width        = Info->Mode[Nth].Width;

	*Height       = Info->Mode[Nth].Height;

	*BitsPerPixel = Info->Mode[Nth].BitsPerPixel;

	*Flags        = Info->Mode[Nth].Flags;

	return JE_TRUE;

}



