/****************************************************************************************/

/*  ROP.H                                                                               */

/*                                                                                      */

/*  Author: Mike Sandige                                                                */

/*  Description:  This defines the available rops for the software driver triangle      */

/*                rasterizer.                                                           */

/*                                                                                      */

/*  The contents of this file are subject to the Jet3D Public License                   */

/*  Version 1.02 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.jet3d.com                                                                */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*  The Original Code is Jet3D, released December 12, 1999.                             */

/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */

/*                                                                                      */

/****************************************************************************************/

#ifndef ROP_H

#define ROP_H



#ifdef __cplusplus

extern "C" {

#endif



	

//	light = gouraud(g),map(m)

//  alpha = none(-), map only(m), flat(f), map and flat(mf)

//  texture= none(-), textured(+), 

//			 textured with bilinear filter(f), textured with clamped bilinear filter(c)



//  if these were bits (they aren't) 

//   Texture 3 bits  (texture,filter,clamp)

//   Light   1 bit   (gouraud/map) 

//   Alpha   2 bits  (map,flat)

//   Z       2 bits  (set,test)

//   span    1 bit   (set&test/not)

//   Total   10 bits  (or 1024 possible rops)



typedef enum {

			 

//ROP ID											//	 texture   light  alpha		z		z	  	span	span	

													//								test	set		test	set							  

// Untextured:

JE_ROP_LSHADE,  									//	|	-	|	g	|	-	|	-	|	-	|	-	|	-	|			

JE_ROP_LSHADE_ZSET,  								//	|	-	|	g	|	-	|	-	|	+	|	-	|	-	|			

JE_ROP_LSHADE_ZTEST,  								//	|	-	|	g	|	-	|	+	|	-	|	-	|	-	|			

JE_ROP_LSHADE_ZTESTSET,  							//	|	-	|	g	|	-	|	+	|	+	|	-	|	-	|			

JE_ROP_LSHADE_AFLAT,								//	|	-	|	g	|	f	|	-	|	-	|	-	|	-	|			

JE_ROP_LSHADE_AFLAT_ZSET,							//	|	-	|	g	|	f	|	-	|	+	|	-	|	-	|			

JE_ROP_LSHADE_AFLAT_ZTEST,							//	|	-	|	g	|	f	|	+	|	-	|	-	|	-	|			

JE_ROP_LSHADE_AFLAT_ZTESTSET,						//	|	-	|	g	|	f	|	+	|	+	|	-	|	-	|			

// Textured:

JE_ROP_TMAP_LSHADE,  								//	|	+	|	g	|	-	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_ZSET,							//	|	+	|	g	|	-	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_ZTEST,  							//	|	+	|	g	|	-	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_ZTESTSET,						//	|	+	|	g	|	-	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_LMAP_ZSET_SBUF,  						//	|	+	|	m	|	-	|	-	|	+	|	+	|	+	|			

JE_ROP_TMAP_LSHADE_ZSET_SBUF,						//	|	+	|	g	|	-	|	-	|	+	|	+	|	+	|			

JE_ROP_TMAP_LMAP_ZTESTSET,							//	|	+	|	m	|	-	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AFLAT,							//	|	+	|	g	|	f	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AFLAT_ZSET,						//	|	+	|	g	|	f	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AFLAT_ZTEST,						//	|	+	|	g	|	f	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AFLAT_ZTESTSET,					//	|	+	|	g	|	f	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP,							//	|	+	|	g	|	m	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP_ZSET,						//	|	+	|	g	|	m	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP_ZTEST,						//	|	+	|	g	|	m	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP_ZTESTSET,					//	|	+	|	g	|	m	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_LMAP_AMAP,								//	|	+	|	m	|	m	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_LMAP_AMAP_ZSET,							//	|	+	|	m	|	m	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_LMAP_AMAP_ZTEST,						//	|	+	|	m	|	m	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_LMAP_AMAP_ZTESTSET,						//	|	+	|	m	|	m	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_LMAP_AFLAT_ZTESTSET,					//	|	+	|	m	|	f	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP_AFLAT,						//	|	+	|	g	|	mf	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP_AFLAT_ZSET,					//	|	+	|	g	|	mf	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP_AFLAT_ZTEST,				//	|	+	|	g	|	mf	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_LSHADE_AMAP_AFLAT_ZTESTSET,				//	|	+	|	g	|	mf	|	+	|	+	|	-	|	-	|			

// Textured with filter:

JE_ROP_TMAP_BFILT_LSHADE,  							//	|	f	|	g	|	-	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_ZSET,						//	|	f	|	g	|	-	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_ZTEST,  					//	|	f	|	g	|	-	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_ZTESTSET,					//	|	f	|	g	|	-	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LMAP_ZSET_SBUF,  					//	|	f	|	m	|	-	|	-	|	+	|	+	|	+	|			

JE_ROP_TMAP_BFILT_LSHADE_ZSET_SBUF,					//	|	f	|	g	|	-	|	-	|	+	|	+	|	+	|			

JE_ROP_TMAP_BFILT_LMAP_ZTESTSET,					//	|	f	|	m	|	-	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AFLAT,						//	|	f	|	g	|	f	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AFLAT_ZSET,				//	|	f	|	g	|	f	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AFLAT_ZTEST,				//	|	f	|	g	|	f	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AFLAT_ZTESTSET,			//	|	f	|	g	|	f	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP,						//	|	f	|	g	|	m	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP_ZSET,					//	|	f	|	g	|	m	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP_ZTEST,				//	|	f	|	g	|	m	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP_ZTESTSET,				//	|	f	|	g	|	m	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LMAP_AMAP,						//	|	f	|	m	|	m	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LMAP_AMAP_ZSET,					//	|	f	|	m	|	m	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LMAP_AMAP_ZTEST,					//	|	f	|	m	|	m	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LMAP_AMAP_ZTESTSET,				//	|	f	|	m	|	m	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LMAP_AFLAT_ZTESTSET,				//	|	f	|	m	|	f	|	+	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT,				//	|	f	|	g	|	mf	|	-	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZSET,			//	|	f	|	g	|	mf	|	-	|	+	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST,			//	|	f	|	g	|	mf	|	+	|	-	|	-	|	-	|			

JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTESTSET,		//	|	f	|	g	|	mf	|	+	|	+	|	-	|	-	|			

JE_ROP_END,

} jeROP;





#ifdef __cplusplus

}

#endif





#endif