/****************************************************************************************/

/*  SWTHandle.H                                                                         */

/*                                                                                      */

/*  Author: Mike Sandige, John Pollard                                                  */

/*  Description:  Manager for texture construction and available texture formats for    */

/*                the software driver                                                   */

/*                                                                                      */

/*  The contents of this file are subject to the Jet3D Public License                   */

/*  Version 1.02 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.jet3d.com                                                                */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*  The Original Code is Jet3D, released December 12, 1999.                             */

/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */

/*                                                                                      */

/****************************************************************************************/

#ifndef SWTHANDLE_H

#define SWTHANDLE_H



#include "Dcommon.h"

#include "PixelFormat.h"



// THandle flags

#define THANDLE_UPDATE		(1<<0)		// Force a thandle to be uploaded to the card

#define	THANDLE_TRANS		(1<<2)		// Texture has transparency

#define THANDLE_LOCKED		(1<<3)		// THandle is currently locked (invalid for rendering etc)



typedef struct jeRDriver_THandle jeRDriver_THandle;



jeBoolean			DRIVERCC	SWTHandle_EnumPixelFormats(DRV_ENUM_PFORMAT_CB *Cb, void *Context);

jeBoolean						SWTHandle_FreeAllTextureHandles(void);

jeRDriver_THandle	*DRIVERCC	SWTHandle_CreateTexture(int32 Width, int32 Height, int32 NumMipLevels, const jeRDriver_PixelFormat *PixelFormat);

jeBoolean			DRIVERCC	SWTHandle_DestroyTexture(jeRDriver_THandle *THandle);



jeBoolean			DRIVERCC	SWTHandle_LockTextureHandle(jeRDriver_THandle *THandle, int32 MipLevel, void **Data);

jeBoolean			DRIVERCC	SWTHandle_UnLockTextureHandle(jeRDriver_THandle *THandle, int32 MipLevel);

jeBoolean			DRIVERCC	SWTHandle_GetInfo(jeRDriver_THandle *THandle, int32 MipLevel, jeRDriver_THandleInfo *Info);



jeBoolean			DRIVERCC	SWTHandle_SetPalette(jeRDriver_THandle *THandle, jeRDriver_THandle *PalHandle);

jeRDriver_THandle	*DRIVERCC	SWTHandle_GetPalette(jeRDriver_THandle *THandle);

jeBoolean			DRIVERCC	SWTHandle_SetAlpha(jeRDriver_THandle *THandle, jeRDriver_THandle *PalHandle);

jeRDriver_THandle	*DRIVERCC	SWTHandle_GetAlpha(jeRDriver_THandle *THandle);

int		 						SWTHandle_GetMipCount(jeRDriver_THandle *THandle);

#endif