/****************************************************************************************/

/*  SoftDrv.H                                                                           */

/*                                                                                      */

/*  Author: Mike Sandige                                                                */

/*  Description:  This is the API layer for the Jet3D software driver.                  */

/*                                                                                      */

/*  The contents of this file are subject to the Jet3D Public License                   */

/*  Version 1.02 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.jet3d.com                                                                */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*  The Original Code is Jet3D, released December 12, 1999.                             */

/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */

/*                                                                                      */

/****************************************************************************************/

#ifndef SOFTDRV_H

#define SOFTDRV_H



#include "Dcommon.h"

#include "Display.h"





#ifdef __cplusplus

extern "C" {

#endif



extern DRV_Window			 ClientWindow;



extern Display				*SD_Display;

extern jeBoolean             SD_ProcessorHas3DNow;

extern jeBoolean             SD_ProcessorHasMMX;

extern jeBoolean			 SD_DIBDisplayMode;

extern jeBoolean			 SD_Active;

extern DRV_Driver			 SOFTDRV;

extern int32				 RenderMode;



JETAPI	void * jeEngine_SoftwareDriver(void);



#ifdef __cplusplus

}

#endif



#endif