/****************************************************************************************/

/*  Span.C                                                                              */

/*                                                                                      */

/*  Author: Mike Sandige                                                                */

/*  Description:  Span abstracts and contains all the various ROP functions.            */

/*                                                                                      */

/*  The contents of this file are subject to the Jet3D Public License                   */

/*  Version 1.02 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.jet3d.com                                                                */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*  The Original Code is Jet3D, released December 12, 1999.                             */

/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */

/*                                                                                      */

/****************************************************************************************/

#include <assert.h>

#include "Span.h"

#include "Triangle.h"

#include "BaseType.h"



#define min(a, b) (((a) < (b)) ? (a) : (b))  



static uint16 RLUT_4X[256];

static uint16 GLUT_4X[256];

static uint16 BLUT_4X[256];

static uint16 Span_OneMinusAlpha[16] = // Alpha is 16 values (5 bits).  1 = 16, 0 = 0

	{  16, 15, 14, 13, 12, 11, 10,  9,  7,  6,  5,  4,  3,  2,  1,  0}; 



int32 URight, VRight, RRight,GRight,BRight;	// Globals for optimal access and sharing 

											// between the lighting sampler and the rop 

											// span functions



void JETCC Span_LightMapSample(void);





typedef struct

{

	jeROP ROP;



	Span_DrawFunction Active;

	Span_DrawFunction Function[JE_SPAN_HARDWARE_VERSIONS][JE_SPAN_DESTINATION_FORMATS];

} Span_FunctionTableEntry;





void JETCC Span_C_TMAP_LMAP_Z1(void);



#define SPANROP LSHADE

		void JETCC Span_C_LSHADE_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + D565

		void JETCC Span_C_LSHADE_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP LSHADE + ZSET 

		void JETCC Span_C_LSHADE_ZSET_555(void)	{

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + ZSET + D565

		void JETCC Span_C_LSHADE_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP LSHADE + ZTEST 

		void JETCC Span_C_LSHADE_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + ZTEST + D565

		void JETCC Span_C_LSHADE_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP LSHADE + ZTEST + ZSET

		void JETCC Span_C_LSHADE_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + ZTEST + ZSET + D565

		void JETCC Span_C_LSHADE_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP LSHADE + AFLAT

		void JETCC Span_C_LSHADE_AFLAT_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + AFLAT + D565

		void JETCC Span_C_LSHADE_AFLAT_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP LSHADE + AFLAT + ZSET

		void JETCC Span_C_LSHADE_AFLAT_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + AFLAT + ZSET + D565

		void JETCC Span_C_LSHADE_AFLAT_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP LSHADE + AFLAT + ZTEST

		void JETCC Span_C_LSHADE_AFLAT_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + AFLAT + ZTEST + D565

		void JETCC Span_C_LSHADE_AFLAT_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP LSHADE + AFLAT + ZTEST + ZSET

		void JETCC Span_C_LSHADE_AFLAT_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP LSHADE + AFLAT + ZTEST + ZSET + D565

		void JETCC Span_C_LSHADE_AFLAT_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}

//--------TEXTURED ROPS----------------------------------------------------

#define SPANROP TMAP + LSHADE 

		void JETCC Span_C_TMAP_LSHADE_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + D565

		void JETCC Span_C_TMAP_LSHADE_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + ZSET

		void JETCC Span_C_TMAP_LSHADE_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + ZSET + D565

		void JETCC Span_C_TMAP_LSHADE_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + ZTEST

		void JETCC Span_C_TMAP_LSHADE_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + ZTEST + D565

		void JETCC Span_C_TMAP_LSHADE_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + ZTEST + ZSET

		void JETCC Span_C_TMAP_LSHADE_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_LSHADE_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LMAP + ZSET 

		void JETCC Span_C_TMAP_LMAP_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LMAP + ZSET + D565

		void JETCC Span_C_TMAP_LMAP_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LMAP + ZTEST + ZSET 

		void JETCC Span_C_TMAP_LMAP_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LMAP + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_LMAP_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AFLAT

		void JETCC Span_C_TMAP_LSHADE_AFLAT_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AFLAT + D565

		void JETCC Span_C_TMAP_LSHADE_AFLAT_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AFLAT + ZSET

		void JETCC Span_C_TMAP_LSHADE_AFLAT_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AFLAT + ZSET + D565 

		void JETCC Span_C_TMAP_LSHADE_AFLAT_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AFLAT + ZTEST

		void JETCC Span_C_TMAP_LSHADE_AFLAT_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AFLAT + ZTEST + D565 

		void JETCC Span_C_TMAP_LSHADE_AFLAT_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AFLAT + ZTEST + ZSET

		void JETCC Span_C_TMAP_LSHADE_AFLAT_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AFLAT + ZTEST + ZSET + D565 

		void JETCC Span_C_TMAP_LSHADE_AFLAT_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP 

		void JETCC Span_C_TMAP_LSHADE_AMAP_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP + ZSET

		void JETCC Span_C_TMAP_LSHADE_AMAP_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + ZSET + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP + ZTEST

		void JETCC Span_C_TMAP_LSHADE_AMAP_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + ZTEST + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP + ZTEST + ZSET

		void JETCC Span_C_TMAP_LSHADE_AMAP_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LMAP + AMAP 

		void JETCC Span_C_TMAP_LMAP_AMAP_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LMAP + AMAP + D565

		void JETCC Span_C_TMAP_LMAP_AMAP_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LMAP + AMAP + ZSET

		void JETCC Span_C_TMAP_LMAP_AMAP_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LMAP + AMAP + ZSET + D565

		void JETCC Span_C_TMAP_LMAP_AMAP_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LMAP + AMAP + ZTEST

		void JETCC Span_C_TMAP_LMAP_AMAP_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LMAP + AMAP + ZTEST + D565

		void JETCC Span_C_TMAP_LMAP_AMAP_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LMAP + AMAP + ZTEST + ZSET

		void JETCC Span_C_TMAP_LMAP_AMAP_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LMAP + AMAP + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_LMAP_AMAP_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LMAP + AFLAT + ZTEST + ZSET

		void JETCC Span_C_TMAP_LMAP_AFLAT_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LMAP + AFLAT + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_LMAP_AFLAT_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP + AFLAT 

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + AFLAT + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP + AFLAT + ZSET 

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + AFLAT + ZSET + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP + AFLAT + ZTEST

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + AFLAT + ZTEST + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + LSHADE + AMAP + AFLAT + ZTEST + ZSET

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + LSHADE + AMAP + AFLAT + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



//--------TEXTURED FILTERED ROPS----------------------------------------------------

#define SPANROP TMAP + BFILT + LSHADE 

		void JETCC Span_C_TMAP_BFILT_LSHADE_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + ZSET

		void JETCC Span_C_TMAP_BFILT_LSHADE_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + ZTEST

		void JETCC Span_C_TMAP_BFILT_LSHADE_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + ZTEST + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + ZTEST + ZSET

		void JETCC Span_C_TMAP_BFILT_LSHADE_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LMAP + ZSET 

		void JETCC Span_C_TMAP_BFILT_LMAP_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LMAP + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LMAP_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LMAP + ZTEST + ZSET 

		void JETCC Span_C_TMAP_BFILT_LMAP_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LMAP + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LMAP_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AFLAT

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AFLAT + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AFLAT + ZSET

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AFLAT + ZSET + D565 

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AFLAT + ZTEST

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AFLAT + ZTEST + D565 

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AFLAT + ZTEST + ZSET

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AFLAT + ZTEST + ZSET + D565 

		void JETCC Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP 

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP + ZSET

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP + ZTEST

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + ZTEST + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP + ZTEST + ZSET

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LMAP + AMAP 

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LMAP + AMAP + D565

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LMAP + AMAP + ZSET

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LMAP + AMAP + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LMAP + AMAP + ZTEST

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LMAP + AMAP + ZTEST + D565

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LMAP + AMAP + ZTEST + ZSET

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LMAP + AMAP + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LMAP + AFLAT + ZTEST + ZSET

		void JETCC Span_C_TMAP_BFILT_LMAP_AFLAT_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LMAP + AFLAT + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LMAP_AFLAT_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT 

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT + ZSET 

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZSET_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT + ZTEST

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT + ZTEST + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_565(void) {

				#include "Span_Factory.h"

				}



#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT + ZTEST + ZSET

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_ZSET_555(void) {

				#include "Span_Factory.h"

				}

		#define SPANROP TMAP + BFILT + LSHADE + AMAP + AFLAT + ZTEST + ZSET + D565

		void JETCC Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_ZSET_565(void) {

				#include "Span_Factory.h"

				}









Span_FunctionTableEntry Span_FunctionTable[JE_ROP_END] =

{//ROP ID						

{JE_ROP_LSHADE,	  					NULL,{{Span_C_LSHADE_555,Span_C_LSHADE_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_LSHADE_ZSET,  				NULL,{{Span_C_LSHADE_ZSET_555,Span_C_LSHADE_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_LSHADE_ZTEST,  				NULL,{{Span_C_LSHADE_ZTEST_555,Span_C_LSHADE_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_LSHADE_ZTESTSET,  			NULL,{{Span_C_LSHADE_ZTEST_ZSET_555,Span_C_LSHADE_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_LSHADE_AFLAT,				NULL,{{Span_C_LSHADE_AFLAT_555,Span_C_LSHADE_AFLAT_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_LSHADE_AFLAT_ZSET,			NULL,{{Span_C_LSHADE_AFLAT_ZSET_555,Span_C_LSHADE_AFLAT_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_LSHADE_AFLAT_ZTEST,			NULL,{{Span_C_LSHADE_AFLAT_ZTEST_555,Span_C_LSHADE_AFLAT_ZTEST_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_LSHADE_AFLAT_ZTESTSET,		NULL,{{Span_C_LSHADE_AFLAT_ZTEST_ZSET_555,Span_C_LSHADE_AFLAT_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },

// Textured

{JE_ROP_TMAP_LSHADE,  				NULL,{{Span_C_TMAP_LSHADE_555,Span_C_TMAP_LSHADE_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LSHADE_ZSET,			NULL,{{Span_C_TMAP_LSHADE_ZSET_555,Span_C_TMAP_LSHADE_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LSHADE_ZTEST,  		NULL,{{Span_C_TMAP_LSHADE_ZTEST_555,Span_C_TMAP_LSHADE_ZTEST_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LSHADE_ZTESTSET,		NULL,{{Span_C_TMAP_LSHADE_ZTEST_ZSET_555,Span_C_TMAP_LSHADE_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LMAP_ZSET_SBUF,  		NULL,{{Span_C_TMAP_LMAP_ZSET_555,Span_C_TMAP_LMAP_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LSHADE_ZSET_SBUF,		NULL,{{Span_C_TMAP_LSHADE_ZSET_555,Span_C_TMAP_LSHADE_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LMAP_ZTESTSET,	  		NULL,{{Span_C_TMAP_LMAP_ZTEST_ZSET_555,Span_C_TMAP_LMAP_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LSHADE_AFLAT,			NULL,{{Span_C_TMAP_LSHADE_AFLAT_555,Span_C_TMAP_LSHADE_AFLAT_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_LSHADE_AFLAT_ZSET,		NULL,{{Span_C_TMAP_LSHADE_AFLAT_ZSET_555,Span_C_TMAP_LSHADE_AFLAT_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AFLAT_ZTEST,	NULL,{{Span_C_TMAP_LSHADE_AFLAT_ZTEST_555,Span_C_TMAP_LSHADE_AFLAT_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AFLAT_ZTESTSET,	NULL,{{Span_C_TMAP_LSHADE_AFLAT_ZTEST_ZSET_555,Span_C_TMAP_LSHADE_AFLAT_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP,			NULL,{{Span_C_TMAP_LSHADE_AMAP_555,Span_C_TMAP_LSHADE_AMAP_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP_ZSET,		NULL,{{Span_C_TMAP_LSHADE_AMAP_ZSET_555,Span_C_TMAP_LSHADE_AMAP_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP_ZTEST,		NULL,{{Span_C_TMAP_LSHADE_AMAP_ZTEST_555,Span_C_TMAP_LSHADE_AMAP_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP_ZTESTSET,	NULL,{{Span_C_TMAP_LSHADE_AMAP_ZTEST_ZSET_555,Span_C_TMAP_LSHADE_AMAP_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LMAP_AMAP,				NULL,{{Span_C_TMAP_LMAP_AMAP_555,Span_C_TMAP_LMAP_AMAP_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LMAP_AMAP_ZSET,		NULL,{{Span_C_TMAP_LMAP_AMAP_ZSET_555,Span_C_TMAP_LMAP_AMAP_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LMAP_AMAP_ZTEST,		NULL,{{Span_C_TMAP_LMAP_AMAP_ZTEST_555,Span_C_TMAP_LMAP_AMAP_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LMAP_AMAP_ZTESTSET,	NULL,{{Span_C_TMAP_LMAP_AMAP_ZTEST_ZSET_555,Span_C_TMAP_LMAP_AMAP_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LMAP_AFLAT_ZTESTSET,	NULL,{{Span_C_TMAP_LMAP_AFLAT_ZTEST_ZSET_555,Span_C_TMAP_LMAP_AFLAT_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP_AFLAT,			NULL,{{Span_C_TMAP_LSHADE_AMAP_AFLAT_555,Span_C_TMAP_LSHADE_AMAP_AFLAT_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP_AFLAT_ZSET,	NULL,{{Span_C_TMAP_LSHADE_AMAP_AFLAT_ZSET_555,Span_C_TMAP_LSHADE_AMAP_AFLAT_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP_AFLAT_ZTEST,	NULL,{{Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_555,Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_LSHADE_AMAP_AFLAT_ZTESTSET,NULL,{{Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_ZSET_555,Span_C_TMAP_LSHADE_AMAP_AFLAT_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

// Textured filtered

{JE_ROP_TMAP_BFILT_LSHADE,  				NULL,{{Span_C_TMAP_BFILT_LSHADE_555,Span_C_TMAP_BFILT_LSHADE_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LSHADE_ZSET,			NULL,{{Span_C_TMAP_BFILT_LSHADE_ZSET_555,Span_C_TMAP_BFILT_LSHADE_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LSHADE_ZTEST,  		NULL,{{Span_C_TMAP_BFILT_LSHADE_ZTEST_555,Span_C_TMAP_BFILT_LSHADE_ZTEST_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LSHADE_ZTESTSET,		NULL,{{Span_C_TMAP_BFILT_LSHADE_ZTEST_ZSET_555,Span_C_TMAP_BFILT_LSHADE_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LMAP_ZSET_SBUF,  		NULL,{{Span_C_TMAP_BFILT_LMAP_ZSET_555,Span_C_TMAP_BFILT_LMAP_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LSHADE_ZSET_SBUF,		NULL,{{Span_C_TMAP_BFILT_LSHADE_ZSET_555,Span_C_TMAP_BFILT_LSHADE_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LMAP_ZTESTSET,	  		NULL,{{Span_C_TMAP_BFILT_LMAP_ZTEST_ZSET_555,Span_C_TMAP_BFILT_LMAP_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LSHADE_AFLAT,			NULL,{{Span_C_TMAP_BFILT_LSHADE_AFLAT_555,Span_C_TMAP_BFILT_LSHADE_AFLAT_565},{NULL,NULL},{NULL,NULL}} },

{JE_ROP_TMAP_BFILT_LSHADE_AFLAT_ZSET,		NULL,{{Span_C_TMAP_BFILT_LSHADE_AFLAT_ZSET_555,Span_C_TMAP_BFILT_LSHADE_AFLAT_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AFLAT_ZTEST,	NULL,{{Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_555,Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AFLAT_ZTESTSET,	NULL,{{Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_ZSET_555,Span_C_TMAP_BFILT_LSHADE_AFLAT_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP,			NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_555,Span_C_TMAP_BFILT_LSHADE_AMAP_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP_ZSET,		NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_ZSET_555,Span_C_TMAP_BFILT_LSHADE_AMAP_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP_ZTEST,		NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_555,Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP_ZTESTSET,	NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_ZSET_555,Span_C_TMAP_BFILT_LSHADE_AMAP_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LMAP_AMAP,				NULL,{{Span_C_TMAP_BFILT_LMAP_AMAP_555,Span_C_TMAP_BFILT_LMAP_AMAP_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LMAP_AMAP_ZSET,		NULL,{{Span_C_TMAP_BFILT_LMAP_AMAP_ZSET_555,Span_C_TMAP_BFILT_LMAP_AMAP_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LMAP_AMAP_ZTEST,		NULL,{{Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_555,Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LMAP_AMAP_ZTESTSET,	NULL,{{Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_ZSET_555,Span_C_TMAP_BFILT_LMAP_AMAP_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LMAP_AFLAT_ZTESTSET,	NULL,{{Span_C_TMAP_BFILT_LMAP_AFLAT_ZTEST_ZSET_555,Span_C_TMAP_BFILT_LMAP_AFLAT_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT,			NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_555,Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZSET,	NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZSET_555,Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST,	NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_555,Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_565},{NULL,NULL},{NULL,NULL}} },	

{JE_ROP_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTESTSET,NULL,{{Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_ZSET_555,Span_C_TMAP_BFILT_LSHADE_AMAP_AFLAT_ZTEST_ZSET_565},{NULL,NULL},{NULL,NULL}} },	

};





jeBoolean JETCC Span_SetOutputMode( jeSpan_DestinationFormat DestFormat, jeSpan_CPU CPU)

{

	int i;



	assert( DestFormat >= 0 );

	assert( DestFormat < JE_SPAN_DESTINATION_FORMATS );

	assert( CPU >= 0 );

	assert( CPU < JE_SPAN_HARDWARE_VERSIONS );

	

	for (i=0; i< JE_ROP_END; i++)

	{

		assert( Span_FunctionTable[i].ROP == i );



		Span_FunctionTable[i].Active = Span_FunctionTable[i].Function[JE_SPAN_HARDWARE_INTEL][DestFormat];



		if (Span_FunctionTable[i].Function[CPU][DestFormat]!=NULL)

			Span_FunctionTable[i].Active = Span_FunctionTable[i].Function[CPU][DestFormat];

	}



	// Setup LUT's for RGB shading

	switch (DestFormat)

	{

		case JE_SPAN_DESTINATION_FORMAT_555:

		{

			for (i=0; i< 256; i++)

			{

				int32		Val;



				Val = min(255, i<<1);



				RLUT_4X[i] = (uint16)((Val>>3)<<10);

				GLUT_4X[i] = (uint16)((Val>>3)<<5);

				BLUT_4X[i] = (uint16)((Val>>3)<<0);

			}

			break;

		}



		case JE_SPAN_DESTINATION_FORMAT_565:

		{

			for (i=0; i< 256; i++)

			{

				int32		Val;



				Val = min(255, i<<1);



				RLUT_4X[i] = (uint16)((Val>>3)<<11);

				GLUT_4X[i] = (uint16)((Val>>2)<<5);

				BLUT_4X[i] = (uint16)((Val>>3)<<0);

			}

			break;

		}



		default:

			assert(0);		// This is a programmatic error, NOT run-time

	}



	return JE_TRUE;

}



Span_DrawFunction JETCC Span_GetDrawFunction(jeROP ROP)

{

	assert( ROP >= 0 );

	assert( ROP < JE_ROP_END );

	assert( Span_FunctionTable[ROP].ROP == ROP );

	assert( Span_FunctionTable[ROP].Active != NULL );



	return Span_FunctionTable[ROP].Active;

}



									// Palette format is X B G R

									// 16 bit 555 format is xRGB

						#ifdef NOISE_FILTER

										*(DestBits++) = (DESTPIXEL) (	(((((Color&0xFF)*R)+Triangle.RandomTable[Triangle.RandomTableIndex++])>>16)&0x7C00) 

													 |	((((((Color&0xFF00)>>8)*G)+Triangle.RandomTable[Triangle.RandomTableIndex++])>>21)&0x3E0)

													 |	(((((Color&0xFF0000)>>16)*B)+Triangle.RandomTable[Triangle.RandomTableIndex++])>>26) );

						#endif

						



void JETCC Span_LightMapSample(void)

{	// use bilinear filter to sample the lightmap 

	int32 LMU,LMV;

	unsigned char *LM0,*LM1;

	unsigned char *LM2,*LM3;

	int C0,C1;

	int C2,C3;

	int P0,P2;

	int C01,C23;

	int UFract01,VFract01;

	

	LMU = ((URight - Triangle.LightMapShiftU)>>8) * Triangle.LightMapScaleU;

	//LMU = (URight>>8)*Triangle.LightMapScaleU - Triangle.LightMapShiftU;

	// Clamp LMU to stay bounded to lightmap (no tiling)

	if (LMU<0) LMU=0;

	if (LMU>Triangle.LightMapMaxU)	LMU = Triangle.LightMapMaxU;



	LMV = ((VRight - Triangle.LightMapShiftV)>>8) * Triangle.LightMapScaleV;

	//LMV = (VRight>>8)*Triangle.LightMapScaleV - Triangle.LightMapShiftV;



	// Clamp LMV to stay bounded to lightmap (no tiling)

	if (LMV<0) LMV=0;

	if (LMV>Triangle.LightMapMaxV) LMV = Triangle.LightMapMaxV;

	

	// address base corner into lightmap by LMU,LMV

	LM0 = Triangle.LightMapBits + (3*(LMU>>16) + TOPDOWN_OR_BOTTOMUP((LMV>>16) * Triangle.LightMapStride));

	#pragma message ("is there a clamping problem here somewhere?  see a hi-res lightmap only rendering...")



#if 1

	// address other corners, clamping

		if ((LMV>>16) < (Triangle.LightMapHeight-1)) 

			LM2 = LM0 + TOPDOWN_OR_BOTTOMUP(Triangle.LightMapStride);

		else

			LM2 = LM0;

		if ((LMU>>16) < (Triangle.LightMapWidth-1))

			{

				LM1 = LM0 + 3;

				LM3 = LM2 + 3;

			}

		else

			{

				LM1 = LM0;

				LM3 = LM2;

			}

		#define RES 7

		UFract01 = (LMU&0xFFFF)>>(16-RES);

		VFract01 = (LMV&0xFFFF)>>(16-RES);

		C0 = *(unsigned int *)LM0;

		C1 = *(unsigned int *)LM1;

		C2 = *(unsigned int *)LM2;

		C3 = *(unsigned int *)LM3;



		P0 = C0 & 0xFF00FF;

		P2 = C2 & 0xFF00FF;

		C01 = (P0 + (( ( (C1&0xFF00FF) - P0 ) * UFract01)>>RES))&0xFF00FF;

		C23 = (P2 + (( ( (C3&0xFF00FF) - P2 ) * UFract01)>>RES))&0xFF00FF;

		P0 =(   C01     + (((  C23 -  C01 ) * VFract01)>>RES));//R&B

		RRight = (P0 & 0xFF)<<RGB_FXP_SHIFTER;

		BRight = ((P0 >> 16)&0xFF)<<RGB_FXP_SHIFTER;



		P0 = C0 & 0xFF00;

		P2 = C2 & 0xFF00;

		C01 = P0 + (( ( ((C1)&0xFF00) - P0 ) * UFract01)>>RES);

		C23 = P2 + (( ( ((C3)&0xFF00) - P2 ) * UFract01)>>RES);

		P0 = (   C01     + (((  C23 -  C01 ) * VFract01)>>RES))&0xFF00; //G

		GRight = ((P0>>8)&0xFF)<<RGB_FXP_SHIFTER;

							

#endif

#if 0

	#if 1

		// address other corners, clamping

		if ((LMV>>16) < (Triangle.LightMapHeight-1)) 

			LM2 = LM0 + TOPDOWN_OR_BOTTOMUP(Triangle.LightMapStride);

		else

			LM2 = LM0;

		if ((LMU>>16) < (Triangle.LightMapWidth-1))

			{

				LM1 = LM0 + 3;

				LM3 = LM2 + 3;

			}

		else

			{

				LM1 = LM0;

				LM3 = LM2;

			}

		UFract01 = (LMU&0xFFFF);

		VFract01 = (LMV&0xFFFF);

		

		C01 =    (*LM0) + ((( *LM1 - *LM0 ) * UFract01)>>16);		

		C23 =    (*LM2) + ((( *LM3 - *LM2 ) * UFract01)>>16);		

		RRight =(   C01     + (((  C23 -  C01 ) * VFract01)>>16))<<RGB_FXP_SHIFTER;



		LM0++; LM1++;

		C01 =    (*LM0) + ((( *LM1 - *LM0 ) * UFract01)>>16);		

		

		LM2++; LM3++;

		C23 =    (*LM2) + ((( *LM3 - *LM2 ) * UFract01)>>16);		

		GRight =(   C01     + (((  C23 -  C01 ) * VFract01)>>16))<<RGB_FXP_SHIFTER;			



		LM0++; LM1++; 

		C01 =    (*LM0) + ((( *LM1 - *LM0 ) * UFract01)>>16);		



		LM2++; LM3++;

		C23 =    (*LM2) + ((( *LM3 - *LM2 ) * UFract01)>>16);		

		BRight =(   C01 + (((  C23 -  C01 ) * VFract01)>>16))<<RGB_FXP_SHIFTER;			

	#else

		RRight = *LM0<<RGB_FXP_SHIFTER; LM0++;

		GRight = *LM0<<RGB_FXP_SHIFTER; LM0++;

		BRight = *LM0<<RGB_FXP_SHIFTER; 

		#pragma message ("lightmap filtering disabled")

	#endif

#endif

	//R=RRight;G=GRight;B=BRight;

	//dR = dG= dB = 0;

}

	



