/****************************************************************************************/

/*  Span.H                                                                              */

/*                                                                                      */

/*  Author: Mike Sandige                                                                */

/*  Description:  Span abstracts and contains all the various ROP functions.            */

/*                                                                                      */

/*  The contents of this file are subject to the Jet3D Public License                   */

/*  Version 1.02 (the "License"); you may not use this file except in                   */

/*  compliance with the License. You may obtain a copy of the License at                */

/*  http://www.jet3d.com                                                                */

/*                                                                                      */

/*  Software distributed under the License is distributed on an "AS IS"                 */

/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */

/*  the License for the specific language governing rights and limitations              */

/*  under the License.                                                                  */

/*                                                                                      */

/*  The Original Code is Jet3D, released December 12, 1999.                             */

/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */

/*                                                                                      */

/****************************************************************************************/

#ifndef SPAN_H

#define SPAN_H



#include "BaseType.h"

#include "Rop.h"



#ifdef __cplusplus

extern "C" {

#endif



typedef void (JETCC *Span_DrawFunction)(void);



typedef enum 

{

	JE_SPAN_DESTINATION_FORMAT_555,

	JE_SPAN_DESTINATION_FORMAT_565,



	JE_SPAN_DESTINATION_FORMATS

} jeSpan_DestinationFormat;



typedef enum

{

	JE_SPAN_HARDWARE_INTEL,

	JE_SPAN_HARDWARE_MMX,

	JE_SPAN_HARDWARE_AMD,



	JE_SPAN_HARDWARE_VERSIONS

} jeSpan_CPU;



jeBoolean JETCC Span_SetOutputMode( jeSpan_DestinationFormat DestFormat, jeSpan_CPU CPU);



Span_DrawFunction JETCC Span_GetDrawFunction(jeROP ROP);





#ifdef __cplusplus

}

#endif





#endif

