/****************************************************************************************/
/*  Display.H                                                                           */
/*                                                                                      */
/*  Author:  Mike Sandige                                                               */
/*  Description:  Abstracts all low-level display surfaces into a single API            */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
// Display
//   display manager 
//
//   manages 
//     DIB format window displays
//     DDRAW format fullscreen displays


#ifndef Display_H
#define Display_H

#include "basetype.h"
#include "DisplayModeInfo.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef enum { DISPLAY_DIB_WINDOW, DISPLAY_DDRAW_FULLSCREEN, DISPLAY_COUNT } Display_Type;

typedef struct Display Display;

jeBoolean Display_GetDisplayInfo(		Display_Type	 DisplayType,
										char			*DescriptionString, 
										unsigned int	 DescriptionStringMaxLength,
										DisplayModeInfo *Info);

jeBoolean Display_GetPixelFormat	(	const Display *D,
										//int32       *pixel_pitch,
										int32       *bytes_per_pixel,
										int32       *R_shift,
										uint32      *R_mask,
										int32       *R_width,
										int32       *G_shift,
										uint32      *G_mask,
										int32       *G_width,
										int32       *B_shift,
										uint32      *B_mask,
										int32       *B_width);

void	Display_GetDisplayFormat(		const Display *D,
										Display_Type *DisplayType,
										int32   *Width, 
										int32   *Height,
										int32   *BitsPerPixel,
										uint32  *Flags);

jeBoolean Display_Blit		(	Display *D);

jeBoolean Display_Wipe		(	Display *D,	
								uint32        color);

jeBoolean Display_Lock		(	Display *D,
								uint8       **ptr,
								int32       *pitch);

jeBoolean Display_Unlock	(	Display *D);

void Display_Destroy		(	Display **pDisplay);

jeBoolean Display_SetActive	(	Display *D, jeBoolean Active );

						 
#ifdef _INC_WINDOWS						                             

jeBoolean Display_UpdateWindow( Display *D);

Display *Display_Create	(	HWND hWindow,
							Display_Type DisplayType,
							int32   RenderSizeAcross, 
							int32   RenderSizeDown,
							int32   Display_BitsPerPixel,
							uint32  Display_Flags);
#endif

#ifdef __cplusplus
}
#endif

#endif
