/****************************************************************************************/ 
/*  DisplayModeInfo.H                                                                   */ 
/*                                                                                      */ 
/*  Author:  Mike Sandige                                                               */ 
/*  Description:  This is a simple container to hold information about available display*/ 
/*                modes for the software driver.                                        */ 
/*                                                                                      */ 
/*  The contents of this file are subject to the Jet3D Public License                   */ 
/*  Version 1.02 (the "License"); you may not use this file except in                   */ 
/*  compliance with the License. You may obtain a copy of the License at                */ 
/*  http://www.jet3d.com                                                                */ 
/*                                                                                      */ 
/*  Software distributed under the License is distributed on an "AS IS"                 */ 
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */ 
/*  the License for the specific language governing rights and limitations              */ 
/*  under the License.                                                                  */ 
/*                                                                                      */ 
/*  The Original Code is Jet3D, released December 12, 1999.                             */ 
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */ 
/*                                                                                      */ 
/****************************************************************************************/ 

#ifndef DisplayModeInfo_H 
#define DisplayModeInfo_H 

#include "basetype.h" 

#ifdef __cplusplus 
extern "C" { 
#endif 


enum    DisplayModeInfo_Flags 
{ 
        SYSTEM                          =1,     //store buffer in system 
        VIDEO                           =2,     //or video ram 
        HARDWARE                        =4,     //refresh choices 
        DMABLT                          =8, 
        FASTBLT                         =16, 
        SAFEBLT                         =32, 
        FLIP                            =64, 
        DMAPAGELOCKREQUIRED     =128,//pagelock for dma req 
        DMAASYNCH                       =256,//can do asynch dma 
        STRETCHMODE                     =512,//stretch to fit 
        MODEXMODE                       =1024 
}; 

typedef struct DisplayModeInfo DisplayModeInfo; 

DisplayModeInfo *       DisplayModeInfo_Create(                 void ); 

void                            DisplayModeInfo_Destroy(                DisplayModeInfo **Info ); 

int                                     DisplayModeInfo_GetModeCount(   DisplayModeInfo *Info); 

jeBoolean                       DisplayModeInfo_AddEntry(               DisplayModeInfo *Info, 
                                                                                                        int Width, 
                                                                                                        int Height, 
                                                                                                        int BitsPerPixel, 
                                                                                                        uint32 Flags ); 

jeBoolean                       DisplayModeInfo_GetNth(                 DisplayModeInfo *Info, 
                                                                                                        int Nth, 
                                                                                                        int *Width, 
                                                                                                        int *Height, 
                                                                                                        int *BitsPerPixel, 
                                                                                                        uint32 *Flags); 

#ifdef __cplusplus 
} 
#endif 


#endif