/****************************************************************************************/
/*  FONT3D.H                                                                            */
/*                                                                                      */
/*  Author: Jason Wood                                                                  */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/

#ifndef FONT3D_H
#define FONT3D_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct jeFont3d jeFont3d;

/////////////////////////////////////////////////////////////////////////////////
// ctor / dtor

jeFont3d* jeFont3d_Create(const char* psFontName);
void jeFont3d_Destroy(jeFont3d** ppFont);

/////////////////////////////////////////////////////////////////////////////////
// functions

jeBoolean jeFont3d_AddGlyphs(jeFont3d* pFont, uint32 rangeMin, uint32 rangeMax,
	int nCurvePoints);

jeActor* jeFont3d_GenActorString(jeFont3d* pFont, const uint32* pString, int len,
	int nCurvePoints, jeBoolean smoothOutline, jeBoolean optimizeMesh);

void jeFont3d_SetBeveler(jeFont3d* pFont, const jeGlyph3d_Beveler* pBeveler);

#ifdef __cplusplus
}
#endif

#endif
