/****************************************************************************************/
/*  GLYPH3D.H                                                                           */
/*                                                                                      */
/*  Author: Jason Wood                                                                  */
/*  Description:                                                                        */
/*                                                                                      */
/*  The contents of this file are subject to the Jet3D Public License                   */
/*  Version 1.02 (the "License"); you may not use this file except in                   */
/*  compliance with the License. You may obtain a copy of the License at                */
/*  http://www.jet3d.com                                                                */
/*                                                                                      */
/*  Software distributed under the License is distributed on an "AS IS"                 */
/*  basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See                */
/*  the License for the specific language governing rights and limitations              */
/*  under the License.                                                                  */
/*                                                                                      */
/*  The Original Code is Jet3D, released December 12, 1999.                             */
/*  Copyright (C) 1996-1999 Eclipse Entertainment, L.L.C. All Rights Reserved           */
/*                                                                                      */
/****************************************************************************************/
#ifndef GLYPH3D_H
#define GLYPH3D_H

#ifdef __cplusplus
extern "C" {
#endif

typedef struct jeGlyph3d								jeGlyph3d;

typedef struct jeGlyph3d_MetricsInfo
{
	float     width, height;
	float     xInc, yInc; // dist from origin to next glyph's origin

}jeGlyph3d_MetricsInfo;

typedef struct jeGlyph3d_BevelInfo			jeGlyph3d_BevelInfo;
typedef struct jeGlyph3d_Beveler				jeGlyph3d_Beveler;

///////////////////////////////////////////////////////////////////////////////////////

JETAPI jeGlyph3d* jeGlyph3d_Create(const char* pFontName, UINT glyphVal, 
	unsigned int nPointsPerCurve, const jeGlyph3d_Beveler* pBeveler);
JETAPI void jeGlyph3d_Destroy(jeGlyph3d** ppGlyph);

JETAPI uint32 jeGlyph3d_GetVal(jeGlyph3d* pGlyph);
JETAPI void jeGlyph3d_GetMetricsInfo(jeGlyph3d* pGlyph, 
	jeGlyph3d_MetricsInfo* pMetricsInfo);

// beveler-related functions
JETAPI jeGlyph3d_Beveler* jeGlyph3d_Beveler_Create(void);
JETAPI void jeGlyph3d_Beveler_Destroy(jeGlyph3d_Beveler** ppBeveler);
JETAPI jeBoolean jeGlyph3d_Beveler_AddBevel(jeGlyph3d_Beveler* pBeveler, 
	float outline, float depth);
JETAPI jeBoolean jeGlyph3d_Beveler_SubtractBevel(jeGlyph3d_Beveler* pBeveler);
JETAPI jeGlyph3d_Beveler_GetNBevels(const jeGlyph3d_Beveler* pBeveler);
JETAPI const jeGlyph3d_BevelInfo* jeGlyph3d_Beveler_GetInfoAt(const jeGlyph3d_Beveler* pBeveler,
	int bevelIndex);
JETAPI jeBoolean jeGlyph3d_Beveler_SetAt(jeGlyph3d_Beveler* pBeveler,
	int bevelIndex, float outline, float depth);

JETAPI jeBoolean jeGlyph3d_GenBone(jeGlyph3d* pGlyph, jeBody* pBody, 
	int parentBoneIndex, int* boneIndex, const char* psBoneName, jeBoolean smoothOutline,
	const jeXForm3d* pXForm);

#ifdef __cplusplus
}
#endif

#endif
